function map = getEpicLinePlotColorMap(order, Ncolors)
%
% function map = getEpicLinePlotColorMap(order, Ncolors)
%
%  Returns color map which includes black as the last color.
%  Input parameters are optional and have default values of
%
%    order   = 'bgr'    (only permutations of b,g,r are valid)
%    Ncolors =  64
%

if nargin<3
  transition = 0.30;  % the parameter needs work for values other than 0.30
end

if nargin<2
  Ncolors = 64;
end
if nargin<1
  order = 'bgr';
end
if transition <= 0.0  |  transition > 1.0
   error('input argument "transition" must be bounded by:  0 < transition <= 1')
end

%       <-T->
% 1|    _____
%  |   /     \
%  |  /       \
%  | /         \
%  |/___________\_ 
%  <-D->

                          
t = 1.0-transition;       
T = t/3.0;                
%D = (2.0-6.0*T) / 3.0;  
D = 1.0 - 3*T;
d = D/2;                 
m = 1.0 / D;             
                         


if strcmp(order,'bgr')
   b=1;  g=2;  r=3;
elseif strcmp(order,'brg')
   b=1;  r=2;  g=3;
elseif strcmp(order,'gbr')
   g=1;  b=2;  r=3;
elseif strcmp(order,'grb')
   g=1;  r=2;  b=3;
elseif strcmp(order,'rbg')
   r=1;  b=2;  g=3;
elseif strcmp(order,'rgb')
   r=1;  g=2;  b=3;
else 
   error(['order "' order '" is not supported'])
end

L=1;  M=2;  R=3;

map(1:Ncolors,1:3) = 0.0;

for c=1:Ncolors
   x = (c-1) / (Ncolors-1);
   tmp_map(1:3) = 0.0;

   % Left Color
   if     x>=0  & x<=d
      tmp_map(L) = 0.5 + m*x;
   elseif x>d   & x<=T+d
      tmp_map(L) = 1.0;
   elseif x>T+d & x<=T+3.0*d
      tmp_map(L) = 1.0 - m*(x-d-T);
   end

   % Middle Color
   if     x>T-d     &   x<=T+d
      tmp_map(M) = 1.0 + m*(x-d-T);
   elseif x>T+d     &   x<=2.0*T+d
      tmp_map(M) = 1.0;
   elseif x>2.0*T+d &   x<=2.0*T+3.0*d
      tmp_map(M) = 1.0 - m*(x-d-2.0*T);
   end

   % Right Color
   if     x>2.0*T-d     &   x<=2.0*T+d
      tmp_map(R) = 1.0 + m*(x-d-2.0*T);
   elseif x>2.0*T+d     &   x<=3.0*T+d
      tmp_map(R) = 1.0;
   elseif x>3.0*T+d     &   x<=3.0*T+3.0*d
      tmp_map(R) = 1.0 - m*(x-d-3.0*T);
   end

   map(c,L) = tmp_map(r);
   map(c,M) = tmp_map(g);
   map(c,R) = tmp_map(b);

   map(c,L) = max( map(c,L), 0.0 );
   map(c,M) = max( map(c,M), 0.0 );
   map(c,R) = max( map(c,R), 0.0 );

   map(c,L) = min( map(c,L), 1.0 );
   map(c,M) = min( map(c,M), 1.0 );
   map(c,R) = min( map(c,R), 1.0 );
end

%map =  [ 0         0    0.5625
%         0         0    0.6250
%         0         0    0.6875
%         0         0    0.7500
%         0         0    0.8125
%         0         0    0.8750
%         0         0    0.9375
%         0         0    1.0000
%         0    0.0625    1.0000
%         0    0.1250    1.0000
%         0    0.1875    1.0000
%         0    0.2500    1.0000
%         0    0.3125    1.0000
%         0    0.3750    1.0000
%         0    0.4375    1.0000
%         0    0.5000    1.0000
%         0    0.5625    1.0000
%         0    0.6250    1.0000
%         0    0.6875    1.0000
%         0    0.7500    1.0000
%         0    0.8125    1.0000
%         0    0.8750    1.0000
%         0    0.9375    1.0000
%         0    1.0000    1.0000
%    0.0625    1.0000    0.9375
%    0.1250    1.0000    0.8750
%    0.1875    1.0000    0.8125
%    0.2500    1.0000    0.7500
%    0.3125    1.0000    0.6875
%    0.3750    1.0000    0.6250
%    0.4375    1.0000    0.5625
%    0.5000    1.0000    0.5000
%    0.5625    1.0000    0.4375
%    0.6250    1.0000    0.3750
%    0.6875    1.0000    0.3125
%    0.7500    1.0000    0.2500
%    0.8125    1.0000    0.1875
%    0.8750    1.0000    0.1250
%    0.9375    1.0000    0.0625
%    1.0000    1.0000         0
%    1.0000    0.9375         0
%    1.0000    0.8750         0
%    1.0000    0.8125         0
%    1.0000    0.7500         0
%    1.0000    0.6875         0
%    1.0000    0.6250         0
%    1.0000    0.5625         0
%    1.0000    0.5000         0
%    1.0000    0.4375         0
%    1.0000    0.3750         0
%    1.0000    0.3125         0
%    1.0000    0.2500         0
%    1.0000    0.1875         0
%    1.0000    0.1250         0
%    1.0000    0.0625         0
%    0.9375         0         0
%    0.8750         0         0
%    0.8125         0         0
%    0.7500         0         0
%    0.6875         0         0
%    0.6250         0         0
%    0.5625         0         0
%    0.5000         0         0 ];
%
