function var_mean = getEpicVarGlobalMean( epic_vars, var_name, nc_file, input_extract_it )
%
% function var_mean = getEpicVarGlobalMean( epic_vars, var_name, nc_file, extract_it )
%
%   Function returns the global mean of variable var_name computing by cell area weighted averaging.  
%   The parameter extract_it is optional and will default to 'last'.  If more than one time is specified 
%   in extract_it, the average is also performed temporally using equal time weighting.
%

TRUE=1;  FALSE=0;
DEG = pi/180.0;

if nargin<3
   error(' Missing input :  epic_vars, var_name, nc_file')
end

if nargin<4
  input_extract_it = 'last';
end


dlt = getNCattribute( nc_file, 'grid_dlt'  );
dln = getNCattribute( nc_file, 'grid_dln'  );
re  = getNCattribute( nc_file, 'planet_re' );
rp  = getNCattribute( nc_file, 'planet_rp' );

var_found = FALSE;
for iv=1:length(epic_vars)
  if strcmp( epic_vars(iv).name, var_name )
     var_found = TRUE;

     if ischar(input_extract_it)
       if strcmp(input_extract_it,'first')
          extract_it = 1;
       elseif strcmp(input_extract_it,'last')
          extract_it = epic_vars(iv).thi - epic_vars(iv).tlo + 1;
       elseif strcmp(input_extract_it,'all')
          extract_it = 1 : (epic_vars(iv).thi - epic_vars(iv).tlo + 1);
       else
          error([' Parameter extract_it = ' extract_it ' is not permitted'])
       end
     else
       extract_it = input_extract_it;
     end
   
     N = size( epic_vars(iv).data );
   
     ILO = epic_vars(iv).ilo;  IHI = epic_vars(iv).ihi;   IOFFSET = 1-ILO;  
     JLO = epic_vars(iv).jlo;  JHI = epic_vars(iv).jhi;   JOFFSET = 1-JLO;
     KLO = epic_vars(iv).klo;  KHI = epic_vars(iv).khi;
   
     clear data longitude latitude
   
     latitude  = getNCvardata(nc_file, epic_vars(iv).dim(3).name);
     longitude = getNCvardata(nc_file, epic_vars(iv).dim(4).name);
   
     if N(2) ~= KHI-KLO+1
        error([' Indexing error.  Check epic_vars(' num2str(iv) ').klo and khi'])
     end
     if N(3) ~= JHI-JLO+1  |  N(3) ~= length(latitude)
        error([' Indexing error.  Check epic_vars(' num2str(iv) ').jlo and jhi'])
     end
     if N(4) ~= IHI-ILO+1  |  N(4) ~= length(longitude)
        error([' Indexing error.  Check epic_vars(' num2str(iv) ').ilo and ihi'])
     end
   
     data = epic_vars(iv).data;
   
     var_mean = 0.0;
     sum_da = 0.0;
     for tn=1:length(extract_it)
        it=extract_it(tn);
        for ik=KLO : KHI
           for J = JLO+JOFFSET : JHI+JOFFSET
              lat  = DEG*latitude(J);
              rln  = re/sqrt( 1.0 + (rp/re*tan(lat))^2.0 );
              rlt  = rln/( cos(lat)*( sin(lat)^2.0 + (re/rp*cos(lat))^2.0 ));          
              da = (rln*dln)*(rlt*dlt);
              sum_da = sum_da + (IHI-ILO+1)*da;
              for I = ILO+IOFFSET : IHI+IOFFSET
                 var_mean = var_mean + data(it,ik,J,I)*da;
              end  % loop over I
           end  % loop over J
        end  % loop over ik
     end  % loop over tn
   
     var_mean = var_mean / sum_da;

  end
end  % loop over variables

if var_found == FALSE
   error(['Could not find variable "' var_name '" not found in epic_vars'])
end

