function var_mean = getEpicVarLayerMean( epic_vars, var_name, input_nc_file, input_extract_ik, input_extract_it )
%
% function var_mean = getEpicVarLayerMean( epic_vars, var_name, nc_file, extract_ik, extract_it )
%
%   Function returns the global mean of variable var_name computing by cell area weighted averaging.  
%   The parameter extract_ik is optional and will default to 'all'. 
%   The parameter extract_it is optional and will default to 'last'.  If more than one time is specified 
%   in extract_it, the AVERAGE IS ALSO PERFORMED TEMPORALLY using equal time weighting.
%

TRUE=1;  FALSE=0;
DEG = pi/180.0;

if nargin<3
   error(' Missing input :  epic_vars, var_name, nc_file')
end

if nargin<4
  input_extract_ik = 'all';
end

if nargin<5
  input_extract_it = 'last';
end

if ischar(input_nc_file)
  nc_file = netcdf( input_nc_file );
elseif isfield(input_nc_file, 'pntr')
  nc_file = input_nc_file(1).pntr;
else
  nc_file = input_nc_file;
end


dlt = getNCattribute( nc_file, 'grid_dlt'  );
dln = getNCattribute( nc_file, 'grid_dln'  );
re  = getNCattribute( nc_file, 'planet_re' );
rp  = getNCattribute( nc_file, 'planet_rp' );

var_found = FALSE;
for iv=1:length(epic_vars)
  if strcmp( epic_vars(iv).name, var_name )
     var_found = TRUE;

     if ischar(input_extract_it)
       if strcmp(input_extract_it,'first')
          extract_it = 1;
       elseif strcmp(input_extract_it,'last')
          extract_it = epic_vars(iv).thi - epic_vars(iv).tlo + 1;
       elseif strcmp(input_extract_it,'all')
          extract_it = 1 : (epic_vars(iv).thi - epic_vars(iv).tlo + 1);
       else
          error([' Parameter extract_it = ' extract_it ' is not permitted'])
       end
     else
       extract_it = input_extract_it;
     end

     if ischar(input_extract_ik)
       if strcmp(input_extract_ik,'top')
          extract_ik = 1;
       elseif strcmp(input_extract_ik,'bottom')
          extract_ik = epic_vars(iv).khi - epic_vars(iv).klo + 1;
       elseif strcmp(input_extract_ik,'all')
          extract_ik = 1 : (epic_vars(iv).khi - epic_vars(iv).klo + 1);
       else
          error([' Parameter extract_ik = ' extract_ik ' is not permitted'])
       end
     else
       extract_ik = input_extract_ik;
     end
   
   
     N = size( epic_vars(iv).data );
   
     ILO = epic_vars(iv).ilo;  IHI = epic_vars(iv).ihi;   IOFFSET = 1-ILO;  
     JLO = epic_vars(iv).jlo;  JHI = epic_vars(iv).jhi;   JOFFSET = 1-JLO;
   
     clear data longitude latitude
   
     latitude  = getNCvardata(nc_file, epic_vars(iv).dim(3).name);
     longitude = getNCvardata(nc_file, epic_vars(iv).dim(4).name);
   
     if N(3) ~= JHI-JLO+1  |  N(3) ~= length(latitude)
        error([' Indexing error.  Check epic_vars(' num2str(iv) ').jlo and jhi'])
     end
     if N(4) ~= IHI-ILO+1  |  N(4) ~= length(longitude)
        error([' Indexing error.  Check epic_vars(' num2str(iv) ').ilo and ihi'])
     end
   
     data = epic_vars(iv).data;
   
     var_mean(1:length(extract_ik)) = 0.0;
     sum_da(1:length(extract_ik))   = 0.0;
     for tn=1:length(extract_it)
        it=extract_it(tn);
        for kk=1:length(extract_ik)
           ik = extract_ik(kk);
           if ik >= epic_vars(iv).klo  &  ik <= epic_vars(iv).khi
              for J = JLO+JOFFSET : JHI+JOFFSET
                 lat  = DEG*latitude(J);
                 rln  = re/sqrt( 1.0 + (rp/re*tan(lat))^2.0 );
                 rlt  = rln/( cos(lat)*( sin(lat)^2.0 + (re/rp*cos(lat))^2.0 ));          
                 da = (rln*dln)*(rlt*dlt);
                 sum_da(kk) = sum_da(kk) + (IHI-ILO+1)*da;
                 for I = ILO+IOFFSET : IHI+IOFFSET
                    var_mean(kk) = var_mean(kk) + data(it,ik,J,I)*da;
                 end  % loop over I
              end  % loop over J
           end % if ik exists
        end  % loop over kk
     end  % loop over tn
   
     for kk=1:length(extract_ik)
        var_mean(kk) = var_mean(kk) / sum_da(kk);
     end

  end
end  % loop over variables


if ischar(input_nc_file)
  close(nc_file);
end

if var_found == FALSE
   error(['Could not find variable "' var_name '" not found in epic_vars'])
end

