function [margins, ratio_height_to_width] = getFigureMargins
%
%  function [margins, ratio_height_to_width] = getFigureMargins
%

ax_id = get(gcf,'Children');

for iax=length(ax_id):-1:1
  if strcmp( get(ax_id(iax),'Type'), 'uimenu' )
    ax_id(iax) = [];
  end
  if strcmp( get(ax_id(iax),'Tag'), 'Colorbar' )
    ax_id(iax) = [];
  end
end

margins.L    = 1.0;
margins.R    = 1.0;
margins.Xgap = 0.0;
margins.B    = 1.0;
margins.T    = 1.0;
margins.Ygap = 0.0;

apos = get(ax_id(iax), 'Position');
for iax=1:length(ax_id)
  margins.L = min(margins.L, apos(1));
  margins.R = min(margins.R, 1.0-(apos(1)+apos(3)) );
  margins.B = min(margins.B, apos(2));
  margins.T = min(margins.T, 1.0-(apos(2)+apos(4)) );

  if iax<length(ax_id)
    apos2 = get(ax_id(iax+1), 'Position');

    if apos(2)==apos2(2)
      if apos(1)<apos2(1)
        margins.Xgap = max( margins.Xgap, apos2(1)-(apos(1)+apos(3)) );
      else
        margins.Xgap = max( margins.Xgap, apos(1)-(apos2(1)+apos2(3)) );
      end
    end
    if apos(1)==apos2(1)
      if apos(2)<apos2(2)
        margins.Ygap = max( margins.Xgap, apos2(2)-(apos(2)+apos(4)) );
      else
        margins.Ygap = max( margins.Xgap, apos(2)-(apos2(2)+apos2(4)) );
      end
    end

    apos = apos2;
  end
end

fpos = get(gcf,'Position');
ratio_height_to_width = fpos(4)*apos(4) / ( fpos(3)*apos(3) );

