function datfiles = getFileNames( input_Prefix, input_Suffix, directory )
%
%        
%

TRUE = 1;
FALSE=0;


if (nargin<3)
  error('Must enter arguments for Prefix, Suffix, directory\n');
end

if ischar( input_Prefix )
  Prefix.valid = input_Prefix;
else
  Prefix = input_Prefix;
end

if ischar( input_Suffix )
  Suffix.valid = input_Suffix;
else
  Suffix = input_Suffix;
end

call_dir = pwd;
datfiles = [];
    
%%Get File Names with Appropriate Suffix 
  eval(['cd ' directory ';']) 
  files = dir; 
   
  n_datfiles=0; 
  for n=1:length(files) 
    if files(n).isdir == 0 
      temp=files(n).name; 
   
      sf_found = FALSE;
      for m=1:length(Suffix)  
        if (length(temp)-length(Suffix(m).valid)+1) > 0 
         if temp( length(temp)-length(Suffix(m).valid)+1 ... 
                : length(temp) ) ... 
                                 == Suffix(m).valid 
           %n_datfiles=n_datfiles+1; 
           %datfiles(n_datfiles).name = temp; 
           sf_found = TRUE;
         end 
        end 

        if ( isfield(Suffix(m), 'invalid') )
          if (length(temp)-length(Suffix(m).invalid)+1) > 0 
           if temp( length(temp)-length(Suffix(m).invalid)+1 ... 
                  : length(temp) ) ... 
                                   == Suffix(m).invalid 
             sf_found = FALSE;
           end 
          end 

        end

        if sf_found == TRUE
           n_datfiles=n_datfiles+1; 
           datfiles(n_datfiles).name = temp; 
        end
      end 
  
    end  
  end 

  %if n_datfiles==0, error('     No Matching Files Found (check suffixes)'), end 
 
 
  if n_datfiles>0
     %%Get File Names with Appropriate Prefixes 
     var=1; 
     for n=1:length(datfiles) 
       pf_found=FALSE; 
       for m=1:length(Prefix)  
         if  length(Prefix(m).valid) <= length( datfiles(var).name )
            if datfiles(var).name(1:length(Prefix(m).valid)) == Prefix(m).valid 
               pf_found=TRUE; 
            end 
         end 
   
         if ( isfield(Prefix(m), 'invalid' ) )
            if datfiles(var).name(1:length(Prefix(m).invalid)) == Prefix(m).invalid 
               pf_found=FALSE; 
            end 
         end
       end  
   
    
       if pf_found==FALSE 
         datfiles(var)=[]; 
         var=var-1; 
       end 
    
       var=var+1; 
     end 
    
     %if var==1, error('     No Matching Files Found (check prefixes)'), end 
   
   
     %%Remove duplicate entries
     if var>1
        for n=length(datfiles):-1:1
           delete_entry = FALSE;
     
           for m=1:length(datfiles)
              if ( m~=n  &  length( datfiles(m).name ) == length( datfiles(n).name ) )
                 if ( datfiles(m).name == datfiles(n).name )
                    delete_entry = TRUE;
                 end
              end
           end
     
           if ( delete_entry == TRUE )
              datfiles(n) = [];
           end
        end
     end
   
   end


   eval(['cd ' call_dir])
return

