function global_means = getGlobalMeanVsPressure( nc_file_input, epic_vars, vars )

FALSE=0; TRUE=1;
if nargin<3
  error(' Missing input nc_file, epic_vars, var_names.')
end


%
% check for valid input
%
if length( epic_vars ) == 0 
  error([' epic_vars is empty'])
end

if isfield(vars,'name')==FALSE
  error([' Input "vars" must have the format vars(:).name .'])
end

if ischar( nc_file_input )
  nc_file = netcdf( nc_file_input );
else
  nc_file = nc_file_input;
end


%
% get indices cooresponding to variable names
%
for iv=1:length(vars)
  var_found=FALSE;
  for iev=1:length(epic_vars)
    if strcmp(vars(iv).name, epic_vars(iev).name)
      var_found=TRUE;
      vars(iv).id = iev;
    end
  end
  if var_found==FALSE
    error([' Could not find variable "' vars(iv).name '" in epic_vars.'])
  end
end


%
% Remap variable to pressure surfaces
%
for iv=1:length(vars)

  if strfind( vars(iv).name, '3' )   |   strcmp( vars(iv).name, 'theta' )
    [epic_vars, x_data_3] = remapEpicVarToNewSurfaces( epic_vars, nc_file,        ...
                                                       vars(iv).name, 'p3', 'p3', ...
                                                       FALSE, 'all' );
  else
    [epic_vars, x_data_2] = remapEpicVarToNewSurfaces( epic_vars, nc_file,        ...
                                                       vars(iv).name, 'p2', 'p2', ...
                                                       FALSE, 'all' );
  end

end


%
% Average each layer in time
%
for iv=1:length(vars)
  clear t_ave_data
  t_ave_data = epic_vars( vars(iv).id ).data;
  epic_vars( vars(iv).id ).data = [];
  epic_vars( vars(iv).id ).data = mean( t_ave_data, 1 );
end
clear t_ave_data


%
% Average each layer in space
%
for iv=1:length(vars)
  clear s_ave_data
  s_ave_data = epic_vars( vars(iv).id ).data;
  N=size(s_ave_data);
  for ik=1:N(2)
    y_data(ik,iv) = mean(mean( s_ave_data(1,ik,:,:) ));
  end
end
clear s_ave_data


%
% Prepare data for output
%
global_means.y_data = y_data;
if length(who('x_data_2'))
  global_means.x_data_2 = x_data_2;
end
if length(who('x_data_3'))
  global_means.x_data_3 = x_data_3;
end


if ischar( nc_file_input )
  close(nc_file)
end

