function reduced_vars = getLongitudeSliceEpicData( epic_vars, var_num, longitude, lon_slice )


TRUE=1;  FALSE=0;

if nargin<4
   error('Invalid input.  Required arguments are:  epic_vars, var_num, longitude, lon_slice')
end

reduced_vars = epic_vars;


   %
   % Change Dimensions
   %
   reduced_vars(var_num).dim(3).name = [];
   reduced_vars(var_num).dim(3).name = reduced_vars(var_num).dim(2).name;
   reduced_vars(var_num).dim(2).name = 'none';

   clear lonlat_data 
   lonlat_data = epic_vars(var_num).data;
   reduced_vars(var_num).data = [];
   N = size(lonlat_data);

   %
   % Find left and right points of longitude
   %
   if N(4)~=length(longitude)
      error(['The size of input variable longitude does not match the size of epic_vars(' ...
              num2str(var_num) ').data( it, ik, jj, :)'])
   end

   iLeft = -1;
   for ii=1 : length(longitude)
      if longitude(ii)<=lon_slice
         iLeft=ii;
      end
   end

   iRight = -1;
   for ii=length(longitude) : -1 : 1
      if longitude(ii)>lon_slice
         iRight=ii;
      end
   end

   if iLeft==-1 |  iRight==-1
      error(['Longitude slice ' num2str(lon_slice) ' does not exist in input variable longitude'])
   end

   wL =  ( longitude(iRight) - lon_slice ) / ( longitude(iRight) - longitude(iLeft) );
   wR = -( longitude(iLeft)  - lon_slice ) / ( longitude(iRight) - longitude(iLeft) );

   %
   % Get longitude slice
   %
   idum=1;
   reduced_vars(var_num).data( 1:N(1), idum, 1:N(2), 1:N(3) )  =  0.0;
   for it=1:N(1)
      for ik=1:N(2)
         for jj=1:N(3)
            reduced_vars(var_num).data( it, idum, ik, jj )  =  wL*lonlat_data( it, ik, jj, iLeft  ) ...
                                                            +  wR*lonlat_data( it, ik, jj, iRight );
         end
      end
   end

   reduced_vars(var_num).ilo = reduced_vars(var_num).jlo;
   reduced_vars(var_num).ihi = reduced_vars(var_num).jhi;
   reduced_vars(var_num).jlo = reduced_vars(var_num).klo;
   reduced_vars(var_num).jhi = reduced_vars(var_num).khi;
   reduced_vars(var_num).klo = 1;
   reduced_vars(var_num).khi = 1;


