function out = getNCattribute( nc_file_input, attname )
%
% function out = getNCattriubte( nc_file, attname )
%
%  Quick extraction of global attributes from a netcdf file.
%
if nargin<2
  error('  two inputs needed:  nc_file, attname')
end

if ischar( nc_file_input )
  nc_file = netcdf( nc_file_input );
else
  nc_file = nc_file_input;
end


attribute = att(nc_file, attname);
if length(attribute)==0
  error('  attribute does not exist')
end

out = attribute{:};

return

