
function defaults = getNCdefaultsObject( nc_file_input )

if nargin<1
  error(' Missing input: nc_file')
end

if ischar( nc_file_input )
  nc_file = netcdf( nc_file_input );
else
  nc_file = nc_file_input;
end


TRUE=1;  FALSE=0;
LAT0 = 45.0;

defaults.geometry           = remove_sloppy_characters( getNCattribute( nc_file, 'def_geometry'          ) );
defaults.system_id          = remove_sloppy_characters( getNCattribute( nc_file, 'def_system_id'         ) );
defaults.f_plane_map        = remove_sloppy_characters( getNCattribute( nc_file, 'def_f_plane_map'       ) );
defaults.eos                = remove_sloppy_characters( getNCattribute( nc_file, 'def_eos'               ) );
defaults.extract_str        = remove_sloppy_characters( getNCattribute( nc_file, 'def_extract_str'       ) );
defaults.species_str        = remove_sloppy_characters( getNCattribute( nc_file, 'def_species_str'       ) );
defaults.layer_spacing_dat  = remove_sloppy_characters( getNCattribute( nc_file, 'def_layer_spacing_dat' ) );

defaults.nk                        = getNCattribute( nc_file, 'def_nk'                         );
defaults.nj                        = getNCattribute( nc_file, 'def_nj'                         );
defaults.ni                        = getNCattribute( nc_file, 'def_ni'                         );
defaults.dt                        = getNCattribute( nc_file, 'def_dt'                         );

defaults.newt_cool_on              = getNCattribute( nc_file, 'def_newt_cool_on'               );
defaults.newt_cool_adjust          = getNCattribute( nc_file, 'def_newt_cool_adjust'           );
defaults.microphysics_on           = getNCattribute( nc_file, 'def_microphysics_on'            );
defaults.vert_diffusion_on         = getNCattribute( nc_file, 'def_vert_diffusion_on'          );
defaults.on                        = getNCattribute( nc_file, 'def_on'                         );
defaults.du_vert                   = getNCattribute( nc_file, 'def_du_vert'                    );
defaults.advection_scheme          = getNCattribute( nc_file, 'def_advection_scheme'           );
defaults.uv_timestep_scheme        = getNCattribute( nc_file, 'def_uv_timestep_scheme'         );
defaults.turbulence_scheme         = getNCattribute( nc_file, 'def_turbulence_scheme'          );

defaults.spacing_type              = getNCattribute( nc_file, 'def_spacing_type'               );
defaults.geostr_init               = getNCattribute( nc_file, 'def_geostr_init'                );
defaults.drag_v                    = getNCattribute( nc_file, 'def_drag_v'                     );
defaults.k_sponge                  = getNCattribute( nc_file, 'def_k_sponge'                   );

defaults.globe_lonbot              = getNCattribute( nc_file, 'def_globe_lonbot'               );
defaults.globe_lontop              = getNCattribute( nc_file, 'def_globe_lontop'               );
defaults.globe_latbot              = getNCattribute( nc_file, 'def_globe_latbot'               );
defaults.globe_lattop              = getNCattribute( nc_file, 'def_globe_lattop'               );
defaults.lat_tp                    = getNCattribute( nc_file, 'def_lat_tp'                     );

defaults.f_plane_half_width        = getNCattribute( nc_file, 'def_f_plane_half_width'         );
defaults.ptop                      = getNCattribute( nc_file, 'def_ptop'                       );
defaults.pbot                      = getNCattribute( nc_file, 'def_pbot'                       );
defaults.p_sigma                   = getNCattribute( nc_file, 'def_p_sigma'                    );
defaults.prandtl                   = getNCattribute( nc_file, 'def_prandtl'                    );
defaults.tau_drag                  = getNCattribute( nc_file, 'def_tau_drag'                   );
defaults.nudiv_nondim              = getNCattribute( nc_file, 'def_nudiv_nondim'               );
defaults.u_scale                   = getNCattribute( nc_file, 'def_u_scale'                    );
defaults.u_spinup_scale            = getNCattribute( nc_file, 'def_u_spinup_scale'             );
defaults.topo_scale                = getNCattribute( nc_file, 'def_topo_scale'                 );
defaults.u_nu_nondim               = getNCattribute( nc_file, 'def_nu_nondim'                  );
defaults.u_time_fp                 = getNCattribute( nc_file, 'def_time_fp'                    );
defaults.mole_fraction             = getNCattribute( nc_file, 'def_mole_fraction'              );
defaults.mole_fraction_over_solar  = getNCattribute( nc_file, 'def_mole_fraction_over_solar'   );
defaults.rh_max                    = getNCattribute( nc_file, 'def_rh_max'                     );



