function out = getNCdimensions( nc_file_or_variable, names_only )
%
% function out = getNCdimensions( nc_file_or_variable, names_only )
%
% Output is a structure containing the variable names
%  and has format  out(:).name
%                  out(:).data   (not given when names_only=TRUE, 
%                                 or when nc_file_or_variable is a variable)
%



TRUE=1; FALSE=0;
if nargin<3
   names_only = FALSE;
end

dimensions = dim(nc_file_or_variable);

%
% get dimension names
%
for id=1:length(dimensions)
  %out(id).name = name( dimensions{id} );
  out(id).name = remove_sloppy_characters( name(dimensions{id}) );
end


%
% retrieve data, and set the appropriate start indices
%
if names_only == FALSE
  variable = var( nc_file_or_variable );
  if length(variable)>0  
     for id=1:length(out)
       out(id).data = variable{id}(:);
     end
  end
end


return

