
function grid = getNCgridObject( nc_file_input )

if nargin<1
  error(' Missing input: nc_file')
end

if ischar( nc_file_input )
  nc_file = netcdf( nc_file_input );
else
  nc_file = nc_file_input;
end


TRUE=1;  FALSE=0;
LAT0 = 45.0;

grid.nk                 = getNCattribute( nc_file, 'grid_nk' );
grid.nj                 = getNCattribute( nc_file, 'grid_nj' );
grid.ni                 = getNCattribute( nc_file, 'grid_ni' );
grid.jtp                = getNCattribute( nc_file, 'grid_jtp' );

grid.wrap               = getNCattribute( nc_file, 'grid_wrap' );
grid.pad                = getNCattribute( nc_file, 'grid_pad' );
grid.jlo                = getNCattribute( nc_file, 'grid_jlo' );
grid.jfirst             = getNCattribute( nc_file, 'grid_jfirst' );
grid.jlast              = getNCattribute( nc_file, 'grid_jlast' );

grid.dlt                = getNCattribute( nc_file, 'grid_dlt' );
grid.dln                = getNCattribute( nc_file, 'grid_dln' );
grid.dt                 = getNCattribute( nc_file, 'grid_dt' );
grid.cfl_dt             = getNCattribute( nc_file, 'grid_cfl_dt' );

grid.geometry           = remove_sloppy_characters( getNCattribute( nc_file, 'grid_geometry' ) );
grid.advection_scheme   = remove_sloppy_characters( getNCattribute( nc_file, 'grid_advection_scheme' ) );
grid.uv_timestep_scheme = remove_sloppy_characters( getNCattribute( nc_file, 'grid_uv_timestep_scheme' ) );
grid.turbulence_scheme  = remove_sloppy_characters( getNCattribute( nc_file, 'grid_turbulence_scheme' ) );

grid.globe_lonbot       = getNCattribute( nc_file, 'grid_globe_lonbot' );
grid.globe_lontop       = getNCattribute( nc_file, 'grid_globe_lontop' );
grid.globe_latbot       = getNCattribute( nc_file, 'grid_globe_latbot' );
grid.globe_lattop       = getNCattribute( nc_file, 'grid_globe_lattop' );

grid.f_plane_map        = remove_sloppy_characters( getNCattribute( nc_file, 'grid_f_plane_map' ) );
grid.f_plane_lat0       = getNCattribute( nc_file, 'grid_f_plane_lat0' );
grid.f_plane_half_width = getNCattribute( nc_file, 'grid_f_plane_half_width' );

grid.k_sponge           = getNCattribute( nc_file, 'grid_k_sponge' );
grid.k_sigma            = getNCattribute( nc_file, 'grid_k_sigma' );
grid.du_vert            = getNCattribute( nc_file, 'grid_du_vert' );

grid.sigmatheta         = getNCattribute( nc_file, 'grid_sigmatheta' );
grid.p3_ref             = getNCattribute( nc_file, 'grid_p3_ref' );
grid.theta3_ref         = getNCattribute( nc_file, 'grid_theta3_ref' );
grid.h_min              = getNCattribute( nc_file, 'grid_h_min' );
grid.pvmin              = getNCattribute( nc_file, 'grid_pvmin' );
grid.pvmax              = getNCattribute( nc_file, 'grid_pvmax' );
grid.tmin               = getNCattribute( nc_file, 'grid_tmin' );
grid.tmax               = getNCattribute( nc_file, 'grid_tmax' );

grid.sgth_bot           = getNCattribute( nc_file, 'grid_sgth_bot' );
grid.sgth_top           = getNCattribute( nc_file, 'grid_sgth_top' );
grid.zeta0              = getNCattribute( nc_file, 'grid_zeta0' );
grid.zeta1              = getNCattribute( nc_file, 'grid_zeta1' );
grid.sigma_sigma        = getNCattribute( nc_file, 'grid_sigma_sigma' );


grid.newt_cool_on       = getNCattribute( nc_file, 'grid_newt_cool_on' );
grid.newt_cool_adjust   = getNCattribute( nc_file, 'grid_newt_cool_adjust' );
grid.microphysics_on    = getNCattribute( nc_file, 'grid_microphysics_on' );
grid.diffusion_direction  = getNCattribute( nc_file, 'grid_diffusion_direction' );
grid.eos                = remove_sloppy_characters( getNCattribute( nc_file, 'grid_eos' ) );

grid.prandtl            = getNCattribute( nc_file, 'grid_prandtl' );
grid.tau_drag           = getNCattribute( nc_file, 'grid_tau_drag' );
grid.drag_v             = getNCattribute( nc_file, 'grid_drag_v' );
grid.drag_zonal_avg     = getNCattribute( nc_file, 'grid_drag_zonal_avg' );
grid.imp_drag_frac      = getNCattribute( nc_file, 'grid_imp_drag_frac' );
grid.pbot               = getNCattribute( nc_file, 'grid_pbot' );
grid.press0             = getNCattribute( nc_file, 'grid_press0' );
grid.mont0              = getNCattribute( nc_file, 'grid_mont0' );
grid.topo_scale         = getNCattribute( nc_file, 'grid_topo_scale' );
grid.nudiv_nondim       = getNCattribute( nc_file, 'grid_nudiv_nondim' );
grid.nu_nondim          = getNCattribute( nc_file, 'grid_nu_nondim' );
grid.nu                 = getNCattribute( nc_file, 'grid_nu' );
grid.aux_a              = getNCattribute( nc_file, 'grid_aux_a' );
grid.aux_b              = getNCattribute( nc_file, 'grid_aux_b' );
grid.aux_c              = getNCattribute( nc_file, 'grid_aux_c' );
grid.aux_fa             = getNCattribute( nc_file, 'grid_aux_fa' );
grid.aux_fb             = getNCattribute( nc_file, 'grid_aux_fb' );
grid.aux_fc             = getNCattribute( nc_file, 'grid_aux_fc' );



%
% The following code is taken from epic_funcs_diag.c
%
  DEG = pi/180.0;

  nj = grid.nj;
  ni = grid.ni;

  omega = getNCattribute( nc_file, 'planet_omega' );
  re    = getNCattribute( nc_file, 'planet_re' );
  rp    = getNCattribute( nc_file, 'planet_rp' );

%
% set_lonlat()
%

  %
  %  Compute lon:
  %
  I=0+1;
  if (strcmp(grid.geometry,'globe') == TRUE)  
    grid.lon(I) = grid.globe_lonbot-(grid.dln);
  else  
    grid.lon(I) = -180.-(grid.dln);
  end
  for ii = 1 : 2*(ni+1)
    I=ii+1;
    grid.lon(I) = grid.lon(I-1)+(grid.dln)*.5;
  end

  %
  % Compute lat:
  %
  J=0+1;
  if (strcmp(grid.geometry,'globe') == TRUE)  
    if (grid.globe_latbot == -90.)  
      grid.lat(J) = -90.+(grid.dlt)*sqrt(.5);
    else  
      grid.lat(J) = grid.globe_latbot;
    end
  elseif (strcmp(grid.geometry,'f-plane') == TRUE)  
    if (strcmp(grid.f_plane_map,'cartesian') == TRUE)  
      grid.lat(J) = -180.-(grid.dlt);
    elseif (strcmp(grid.f_plane_map,'polar') == TRUE)  
      grid.lat(J) = 0.-(grid.dlt);
    end
  else  
    error(['unrecognized geometry ' grid.geometry ]);
  end
  for jj = 1 : 2*(nj+1)
    J=jj+1;
    grid.lat(J) = grid.lat(J-1)+(grid.dlt)*.5;
  end
  if (strcmp(grid.geometry,'globe') == TRUE)  
    J=0+1;
    if (grid.globe_latbot == -90.)  
      % poles are offset by extra dlt*sqrt(.5) 
      grid.lat(J) = -90.;   
    end
    J=2*(nj+1) +1;
    if (grid.globe_lattop == 90.)    
      grid.lat(J) =  90.; 
    end
  elseif (strcmp(grid.geometry,'f-plane') == TRUE)  
    J=2*(nj+1) +1;
    if (strcmp(grid.f_plane_map,'polar') == TRUE)  
      grid.lat(J) = 90.;
    end
  end


%
% set_fmn()
%
  grid.m (1:length(grid.lat)) = 0.0;
  grid.n (1:length(grid.lat)) = 0.0;
  grid.mn(1:length(grid.lat)) = 0.0;

  if (strcmp(grid.geometry,'globe') == TRUE) 
    dlnr  = grid.dln*DEG;
    dltr  = grid.dlt*DEG;
    %for jj = 1 : 2*(nj+1) 
    for jj = 2 : length(grid.lat) -1
      lat  = DEG*grid.lat(jj);
      rln  = re/sqrt( 1.+ (rp/re*tan(lat))^2. );
      rlt  = rln/( cos(lat)*( (sin(lat))^2. + (re/rp*cos(lat))^2. ));

      grid.rln(jj) = rln;
      grid.rlt(jj) = rlt;
      grid.f  (jj) = 2.*omega*sin(lat);
      grid.m  (jj) = 1./(rln*dlnr);
      grid.n  (jj) = 1./(rlt*dltr);
      grid.mn (jj) = grid.m(jj)*grid.n(jj); 
    end
    %
    %  The Arakawa and Lamb (1981) scheme calls for a 
    %  special (3/2)*dlt spacing for n next to the poles,
    %  as illustrated by their Fig. A2; their equation
    %  (A40) specifies mn at the poles.
    %
    %  NOTE: We find that the special spacing next to the poles is more accurately
    %  given by (1.+sqrt(.5))*dlt.  
    %
    if (grid.globe_latbot == -90.) 
      % south pole */
      lat = DEG*grid.lat(1);
      grid.rln(1  )  = 0.;
      grid.rlt(1  )  = re*re/rp;
      grid.f  (1  )  = 2.*omega*sin(lat);
      grid.n  (1+1)  = grid.n(1+1 ) / (1.+sqrt(.5));  
      % wedge shaped area: */
      grid.mn (1+1)  = grid.n(1+1)*grid.n(1+1)/(.5*dlnr);
      grid.mn (1  )  = 2.*grid.mn(1+1);
    else 
      jj = 0;
      J = jj+1;
      lat  = DEG*grid.lat(J);
      rln  = re/sqrt( 1.+ (rp/re*tan(lat))^2. );
      rlt  = rln/( cos(lat)*((sin(lat))^2. + (re/rp*cos(lat))^2.) );

      grid.rln(J) = rln;
      grid.rlt(J) = rlt;
      grid.f  (J) = 2.*omega*sin(lat);
      grid.m  (J) = 1./(rln*dlnr);
      grid.n  (J) = 1./(rlt*dltr);
      grid.mn (J) = grid.m(J)*grid.n(J); 
    end
    if (grid.globe_lattop == 90.) 
      % north pole */
      J = length( grid.lat );
      lat = DEG*grid.lat(J);
      grid.rln(J   )  = 0.;
      grid.rlt(J   )  = re*re/rp;
      grid.f  (J   )  = 2.*omega*sin(lat);
      grid.n  (J -1)  = grid.n(J-1) / (1.+sqrt(.5));
      % wedge shaped area: */
      grid.mn (J -1)  = grid.n(J-1)*grid.n(J-1)/(.5*dlnr);
      grid.mn (J   )  = 2.*grid.mn(J-1);
    else 
      J = length( grid.lat );
      lat  = DEG*grid.lat(J);
      rln  = re/sqrt( 1.+ (rp/re*tan(lat))^2. );
      rlt  = rln/( cos(lat)*( (sin(lat))^2. + (re/rp*cos(lat))^2. ) );

      grid.rln(J) = rln;
      grid.rlt(J) = rlt;
      grid.f  (J) = 2.*omega*sin(lat);
      grid.m  (J) = 1./(rln*dlnr);
      grid.n  (J) = 1./(rlt*dltr);
      grid.mn (J) = grid.m(J)*grid.n(J); 
    end
  elseif (strcmp(grid.geometry,'f-plane') == TRUE) 
    if (strcmp(grid.f_plane_map,'cartesian') == TRUE) 
      lat = DEG*(grid.f_plane_lat0);
      dx  = 2.*(grid.f_plane_half_width)/ni;
      dy  = dx;

      for jj = 0 : 2*(nj+1)
        J=jj+1;
        grid.rln(J) = 1.;
        grid.rlt(J) = 1.;
        grid.f  (J) = 2.*omega*sin(lat);
        grid.m  (J) = 1./dx;
        grid.n  (J) = 1./dy;
        grid.mn (J) = 1./(dx*dy);
      end
    elseif (strcmp(grid.f_plane_map,'polar') == TRUE) 
      lat  = DEG*(grid.f_plane_lat0);
      dlnr = grid.dln*DEG;
      dy   = grid.f_plane_half_width*(grid.dlt/90.);
      rln  = grid.f_plane_half_width+dy;

      for jj = 0 : 2*(nj+1) -1
        J=jj+1;
        dx = rln*dlnr;
        grid.rln(J) = rln;
        grid.rlt(J) = 1.;
        grid.f  (J) = 2.*omega*sin(lat);
        grid.m  (J) = 1./dx;
        grid.n  (J) = 1./dy;
        grid.mn (J) = grid.m(J)*grid.n(J);
        rln         = rln - dy/2.;
      end
      J = 2*(nj+1) + 1;
      % pole */
      grid.rln(J  )  = 0.;
      grid.rlt(J  )  = 1.;
      grid.f  (J  )  = 2.*omega*sin(lat);
      grid.n  (J-1)  = grid.n(J-1) / (1.+sqrt(.5));
      % wedge shaped area: */
      grid.mn (J-1)  = grid.n(J-1)*grid.n(J-1)/(.5*dlnr);
      grid.mn (J  )  = 2.*grid.mn(J-1);
    end
  end

  %
  % Set grid.dy0 = dy at LAT0.
  %
  if (strcmp(grid.geometry,'globe') == TRUE) 
    lat0 = LAT0*DEG;  
    rln  = re/sqrt( 1.+ (rp/re*tan(lat0))^2. );
    rlt  = rln/( cos(lat0)*( (sin(lat0))^2. + (re/rp*cos(lat0))^2. ) );
    grid.dy0 =rlt*grid.dlt*DEG;
  elseif (strcmp(grid.geometry,'f-plane')  == TRUE)  
    if (strcmp(grid.f_plane_map,'polar') == TRUE) 
      grid.dy0 = grid.f_plane_half_width/grid.nj;
    else 
      grid.dy0 = grid.f_plane_half_width/grid.ni;
    end
  else 
    error(['unrecognized grid.geometry ' grid.geometry])
  end


