
function planet = getNCplanetObject( nc_file_input )

if nargin<1
  error(' Missing input: nc_file')
end

if ischar( nc_file_input )
  nc_file = netcdf( nc_file_input );
else
  nc_file = nc_file_input;
end


TRUE=1;  FALSE=0;
LAT0 = 45.0;

planet.name             = remove_sloppy_characters( getNCattribute( nc_file, 'planet_name' ) );
planet.type             = remove_sloppy_characters( getNCattribute( nc_file, 'planet_type' ) );

planet.re               = getNCattribute( nc_file, 'planet_re'           );
planet.rp               = getNCattribute( nc_file, 'planet_rp'           );
planet.omega            = getNCattribute( nc_file, 'planet_omega'        );
planet.g                = getNCattribute( nc_file, 'planet_g'            );

planet.cp               = getNCattribute( nc_file, 'planet_cp'           );
planet.rgas             = getNCattribute( nc_file, 'planet_rgas'         );
planet.cpr              = planet.cp / planet.rgas;
planet.kappa            = 1.0 / planet.cpr;

planet.x_he             = getNCattribute( nc_file, 'planet_x_he'         );
planet.x_h2             = getNCattribute( nc_file, 'planet_x_h2'         );
planet.x_3              = getNCattribute( nc_file, 'planet_x_3'          );

planet.a                = getNCattribute( nc_file, 'planet_a'            );
planet.e                = getNCattribute( nc_file, 'planet_e'            );
planet.orbit_period     = getNCattribute( nc_file, 'planet_orbit_period' );
planet.kinvisc          = getNCattribute( nc_file, 'planet_kinvisc'      );
planet.dynvisc          = getNCattribute( nc_file, 'planet_dynvisc'      );



