function out = getNCvardata( nc_file_input, varname )
%
% function out = getNCvardata( nc_file, varname )
%
%  function is for quick extraction of data from a netcdf file.
%  It should be used sparingly (such as for dimension variables only)
%   since it returns the entire data array for the variable.
%
if nargin<2
  error('  two inputs needed:  nc_file, varname')
end

if ischar( nc_file_input )
  nc_file = netcdf( nc_file_input );
else
  nc_file = nc_file_input;
end

variable = var(nc_file, varname);
if length(variable)==0
  error('  variable does not exist')
end

out = variable(:);

return

