
function num_it = getNumberSnapShots( nc_filepath )

TRUE=1; FALSE=0;

if nargin<1
  error('Input missing "nc_filepath"')
end


%
% Create the list of nc filepaths
%
if ischar(nc_filepath)
   nc_filepath_list.name = nc_filepath;
else
   if isfield(nc_filepath,'name')==FALSE
      error(' parameter "nc_filepath" must be a string indicating the filepath, or a structure nc_filepath(:).name')
   end
   nc_filepath_list = nc_filepath;
end

num_files = length( nc_filepath_list );
for inc=1:num_files 
  if nc_filepath_list(inc).name(1) == '~';
    numchars = length( nc_filepath_list(inc).name );
    if numchars==1
      nc_filepath_list(inc).name = getEnvVariable('HOME');
    else
      nc_filepath_list(inc).name = [ getEnvVariable('HOME') nc_filepath_list(inc).name(2:numchars) ];
    end
  end
end

%
% Open Files
%
max_nc_length = 100000;

for inc=1:num_files 
   nc_path = nc_filepath_list(inc).name;
   nc_file(inc).pntr = netcdf( nc_path, 'nowrite' );
   
   if length(nc_file(inc).pntr) > max_nc_length
     %error('  nc file is longer than the maximum allowed (file might not exist)')
     error(['  nc file "' nc_path '" does not exist'])
   end
end


%
% Find the last valid time index of each NC file 
%   (removes overlaps in time indexing)
%
for inc=num_files-1 : -1 : 1
   clear time_it
   time_it = getNCvardata( nc_file(inc).pntr, 'time' );
   last_valid_file_it(inc) = length( time_it );

   clear time_itp1
   time_itp1 = getNCvardata( nc_file(inc+1).pntr, 'time' );

   if time_it(1) > time_itp1(1)
      error('  Extract files must be given sequentially in time.')
   end 

   clear igt
   igt = find( time_it(length(time_it)) >= time_itp1 );
   if length(igt)>0
      last_valid_file_it(inc) = length( time_it ) - max(igt);
      if last_valid_file_it(inc) < 1
         last_valid_file_it(inc) = 0;
      end
   end
end
clear time_it
time_it = getNCvardata( nc_file(num_files).pntr, 'time' );
last_valid_file_it( num_files ) = length( time_it );


num_it = sum( last_valid_file_it );


%
% Close the nc files
%
for inc=1:length(nc_file)
  close(nc_file(inc).pntr)
end




return

