

            % get zonal velocities
            u_plot_data = plot_data;
            u_latitude  = latitude;
            u_longitude = longitude;
            u_size=size(u_plot_data);
            UILO = ILO;  UIHI = IHI;
            UJLO = JLO;  UJHI = JHI;

            % get meridional velocity componenets 
            clear plot_data lattitude longitude
            var_dims  = epic_vars(iv+1).dim;
            VILO  = epic_vars(iv+1).ilo;     VJLO  = epic_vars(iv+1).jlo;  
            VIHI  = epic_vars(iv+1).ihi;     VJHI  = epic_vars(iv+1).jhi;   
            ILO=VILO;  IHI=VIHI;  JLO=VJLO;  JHI=VJHI;

            latitude  = getNCvardata( nc_file(1).pntr, var_dims(3).name );
            longitude = getNCvardata( nc_file(1).pntr, var_dims(4).name );
            plot_data(:,:) = epic_vars(iv+1).data( it, ik, :, : );
            %latitude  = varbase( getNCvardata( nc_file, var_dims(3).name ),  VJLO );
            %longitude = varbase( getNCvardata( nc_file, var_dims(4).name ),  VILO );
            %plot_data(:,:) = feval( @double, epic_vars(iv+1).data( it, ik, :, : ) );
            %plot_data = varbase( plot_data, [VJLO VILO] );

            % make zonal velocities periodic
            if make_x_data_periodic==TRUE
              I = VIHI+IOFFSET();
              plot_data(:,I+1) = plot_data(:,1);
              longitude(  I+1) = 2.0*longitude(I) - longitude(I-1) ;
              %plot_data(:,VIHI+1) = feval( @double, plot_data(:,VILO) );
              %longitude(  VIHI+1) = feval( @double, varbase(2.0)*longitude(VIHI) - longitude(VIHI-1) );
              VIHI = VIHI+1;
              IHI  = VIHI;
            end

            % see if the meridional velocities need remapped
            remap_v_lon = FALSE; remap_v_lat = FALSE;
            if longitude(1) ~= u_longitude(1)
              remap_v_lon = TRUE;
            end
            if latitude(1) ~= u_latitude(1)
              remap_v_lat = TRUE;
            end

            % prepare meridional velocities for remapping (if necessary), and define v_ variables
            if remap_v_lat==TRUE;
              value_at_poles = 0.0;
              [plot_data latitude] = addValuesAtPoles( plot_data, latitude, value_at_poles );
            end
            if remap_v_lon==TRUE
              % add right edge periodic data
              plot_data(:,VIHI+1 +IOFFSET()) = plot_data(:,VILO+IOFFSET()+make_x_data_periodic) ;
              VIHI = VIHI+1;
              % add left edge periodic data
              for I=VIHI+1 +IOFFSET() : -1 : VILO+1 +IOFFSET()
                 plot_data(:,I) = plot_data(:,I-1) ;
              end
              plot_data(:,1) = plot_data(:,VIHI+ IOFFSET()-make_x_data_periodic) ;
              VILO = VILO-1; 
            end
            
            v_plot_data = plot_data;
            v_latitude  = latitude;
            v_longitude = longitude;
            clear plot_data lattitude longitude


            % re-map meridional velocity onto zonal velocity grid (if necessary)
            if remap_v_lon==TRUE  &  remap_v_lat==TRUE
              %remap_v_plot_data = varbase( [], [UJLO UILO] );
              for jj=UJLO : UJHI
                 ju = jj + (1-UJLO);   J = jj + (1-VJLO);
               
                 for ii=UILO : UIHI
                   iu = ii + (1-UILO);   I = ii + (1-VILO);

                   % this should eventually do a cos(latitude) weighted average
                   remap_v_plot_data(ju,iu) = 0.25*(  v_plot_data(J  ,I) + v_plot_data(J  ,I-1)   ...
                                                    + v_plot_data(J+1,I) + v_plot_data(J+1,I-1) );
                 end
              end
            elseif remap_v_lon==TRUE
              %fprintf('remapping long .... \n')
              for ii=UILO:UIHI
                iu = ii + (1-UILO);   I = ii + (1-VILO);
                remap_v_plot_data(:,iu) = 0.5*( v_plot_data(:  ,I) + v_plot_data(:  ,I-1) ) ;
              end
            elseif remap_v_lat==TRUE
              %fprintf('remapping lat .... \n')
              for jj=UILO:UJHI
                ju = jj + (1-UJLO);   J = jj + (1-VJLO);
                remap_v_plot_data(ju,:) = 0.5*( v_plot_data(J  ,:) + v_plot_data(J+1,:) ) ;
              end
            end  
            if remap_v_lon==TRUE  |  remap_v_lat==TRUE
              clear v_plot_data 
              v_plot_data = remap_v_plot_data;
              clear remap_v_plot_data
            end

            num_points = size(v_plot_data);
            if thin_vector_plot_iters(1)>0
              ith=1;
              while ith<=thin_vector_plot_iters(1)  &  num_points(2)>3
                clear thin_u_plot_data thin_v_plot_data thin_u_longitude
                thin_u_plot_data(:,1) = u_plot_data(:,1);
                thin_v_plot_data(:,1) = v_plot_data(:,1);
                thin_u_longitude(  1) = u_longitude(  1);
                for ii=2:1:(num_points(2)-1)/2
                  thin_u_plot_data(:,ii) = u_plot_data(:,2*ii-1);
                  thin_v_plot_data(:,ii) = v_plot_data(:,2*ii-1);
                  thin_u_longitude(  ii) = u_longitude(  2*ii-1);
                end
                thin_u_plot_data(:,(num_points(2)-1)/2+1) = u_plot_data(:,num_points(2));
                thin_v_plot_data(:,(num_points(2)-1)/2+1) = v_plot_data(:,num_points(2));
                thin_u_longitude(  (num_points(2)-1)/2+1) = u_longitude(  num_points(2));
                
                clear u_plot_data v_plot_data u_longitude
                u_plot_data = thin_u_plot_data;
                v_plot_data = thin_v_plot_data;
                u_longitude = thin_u_longitude;
                clear thin_u_plot_data thin_v_plot_data thin_u_longitude

                num_points = size(u_plot_data);
                UJHI = num_points(1);
                UIHI = num_points(2);
                ith=ith+1;
              end
            end

            if thin_vector_plot_iters(2)>0
              ith=1;
              while ith<=thin_vector_plot_iters(2)  &  num_points(1)>3
                clear thin_u_plot_data thin_v_plot_data thin_u_latitude
                thin_u_plot_data(1,:) = u_plot_data(1,:);
                thin_v_plot_data(1,:) = v_plot_data(1,:);
                thin_u_latitude( 1  ) = u_latitude( 1  );
                for jj=2:1:(num_points(1)-1)/2
                  thin_u_plot_data(jj,:) = u_plot_data(2*jj-1,:);
                  thin_v_plot_data(jj,:) = v_plot_data(2*jj-1,:);
                  thin_u_latitude( jj )  = u_latitude( 2*jj-1  );
                end
                thin_u_plot_data((num_points(1)-1)/2+1,:) = u_plot_data(num_points(1),:);
                thin_v_plot_data((num_points(1)-1)/2+1,:) = v_plot_data(num_points(1),:);
                thin_u_latitude( (num_points(1)-1)/2+1  ) = u_latitude( num_points(1)  );
                
                clear u_plot_data v_plot_data u_latitude
                u_plot_data = thin_u_plot_data;
                v_plot_data = thin_v_plot_data;
                u_latitude = thin_u_latitude;
                clear thin_u_plot_data thin_v_plot_data thin_u_latitude

                num_points = size(u_plot_data);
                UJHI = num_points(1);
                UIHI = num_points(2);
                ith=ith+1;
              end
            end

            % use this to debug the meridional velocity scaling
            %u_plot_data(:,:)=1;            
            %v_plot_data(:,:)=1;            

            clear plot_data longitude latitude
            plot_data = sqrt( u_plot_data.^2 + v_plot_data.^2 ) ;
            
            % reset the meridional velocity scale so that a 45 degree angle 
            %  means u and v are equal (applies only to a SQUARE axis).
            num_points = size(v_plot_data);
            v_plot_data(:,:) = v_plot_data(:,:) * num_points(1) / num_points(2); % * 1.7339;

            %  reset meridional velocity scale again to account for rectangular axis 
            v_plot_data(:,:) = v_plot_data(:,:) *  Xlen(1)/Xlen(2);


            %clear plot_data longitude latitude
            %plot_data = sqrt( u_plot_data.^2 + v_plot_data.^2 ) ;
            
            ILO = UILO;  IHI=UIHI;
            JLO = UJLO;  JHI=UJHI;
            longitude = u_longitude;
            latitude  = u_latitude;

