function reduced_vars = getZonalReducedEpicData( epic_vars, return_type )
%
% function reduced_vars = getZonalReducedEpicData( epic_vars, return_type )
%
% Returns a zonal reduction operation on data.  Options for return_type are:
%                          
%                         0  -  return zonal average (default) 
%                         1  -  return zonal sum  
%                         2  -  return maximum zonal magnitude [i.e., (+/-) MAX( |data| ) ]
%                         3  -  return zonal anomoly [i.e., zonal ave of (data(jj,ii)-pole_to_pole_ave(ii)) ]
%                         4  -  return zonal edie    [i.e., (data(jj,ii) - zonal ave) ]
%

TRUE=1;  FALSE=0;

if nargin<1
   error('No input argument given for epic_vars')
end

if nargin<2
   return_type = 0;
elseif return_type<0 | return_type>4
   error([' return_type = ' num2str(return_type) ' is not supported'])
end



reduced_vars = epic_vars;

for iv=1:length( epic_vars )

   %
   % Change Dimensions
   %
   if return_type ~= 4
     reduced_vars(iv).dim(3).name = [];
     reduced_vars(iv).dim(3).name = reduced_vars(iv).dim(2).name;
     reduced_vars(iv).dim(2).name = 'none';
   end

   clear lonlat_data
   lonlat_data = epic_vars(iv).data;
   reduced_vars(iv).data = [];

   N = size(lonlat_data);
   idum=1;
   reduced_vars(iv).data( 1:N(1), idum, 1:N(2), 1:N(3) )  =  0.0;
   if return_type==0  |  return_type==1
     for it=1:N(1)
        for ik=1:N(2)
           for jj=1:N(3)
              for ii=1:N(4)
                 reduced_vars(iv).data( it, idum, ik, jj )  =  reduced_vars(iv).data( it, idum, ik, jj ) ...
                                                             +           lonlat_data( it, ik  , jj, ii );
              end
           end
        end
     end
  
     if return_type==0
        reduced_vars(iv).data = reduced_vars(iv).data / N(4);
     end

   elseif return_type==2
     for it=1:N(1)
        for ik=1:N(2)
           for jj=1:N(3)
              reduced_vars(iv).data( it, idum, ik, jj )  =  0.0;
              for ii=1:N(4)
                 if abs( lonlat_data(it,ik,jj,ii) ) > abs( reduced_vars(iv).data( it, idum, ik, jj ) )
                   reduced_vars(iv).data( it, idum, ik, jj )  =  lonlat_data(it,ik,jj,ii);
                 end
              end
           end
        end
     end

   elseif return_type==3
     for it=1:N(1)
        for ik=1:N(2)
           merid_mean(1:N(4)) = 0.0;
           for ii=1:N(4)
              for jj=1:N(3)
                 merid_mean(ii)  =  merid_mean(ii)  +  lonlat_data( it, ik  , jj, ii );
              end
              merid_mean(ii) = merid_mean(ii) / N(3);
           end

           for jj=1:N(3)
              reduced_vars(iv).data( it, idum, ik, jj )  =  0.0;
              for ii=1:N(4)
                 reduced_vars(iv).data( it, idum, ik, jj )  =  reduced_vars(iv).data( it, idum, ik, jj ) ...
                                                             + lonlat_data( it, ik  , jj, ii ) - merid_mean(ii);
              end
              reduced_vars(iv).data(it, idum, ik, jj) = reduced_vars(iv).data(it, idum, ik, jj) / N(4);
           end
        end
     end

   elseif return_type==4
     for it=1:N(1)
        for ik=1:N(2)
           for jj=1:N(3)
              for ii=1:N(4)
                 reduced_vars(iv).data( it, idum, ik, jj )  =  reduced_vars(iv).data( it, idum, ik, jj ) ...
                                                             +           lonlat_data( it, ik  , jj, ii );
              end
           end
        end
     end
  
     reduced_vars(iv).data = reduced_vars(iv).data / N(4);

     for it=1:N(1)
        for ik=1:N(2)
           for jj=1:N(3)
              for ii=1:N(4)
                 lonlat_data( it, ik  , jj, ii ) = lonlat_data( it, ik  , jj, ii ) ...
                                                 - reduced_vars(iv).data( it, idum, ik, jj );
              end
           end
        end
     end
     
     reduced_vars(iv).data = [];
     reduced_vars(iv).data = lonlat_data;
     
   end




   if return_type ~= 4
     reduced_vars(iv).ilo = reduced_vars(iv).jlo;
     reduced_vars(iv).ihi = reduced_vars(iv).jhi;
     reduced_vars(iv).jlo = reduced_vars(iv).klo;
     reduced_vars(iv).jhi = reduced_vars(iv).khi;
     reduced_vars(iv).klo = 1;
     reduced_vars(iv).khi = 1;
   end
end
