
function h = get_h( planet, kk, J, I, type, grid_obj)
%
% Calculates h = -1/g dp/dsgth.
%
% (code translated from epic_funcs_diag.c)
%
 
% NOTE :  kk is zero based!

global DRY KHI P3 TOTAL HE_INDEX

  % Check validity of kk
  if (kk < 1  |  kk > 2*grid_obj.nk+2)  
    error(['kk = ' num2str(kk));
  end

  KK = kk+1;

  if (mode(kk,2) == 0)  
    % 
    % Layer value for h. 
    %/
    k = kk/2;
    K=k+1;
    if strcmp(planet.type,'gas-giant')  &  k == grid_obj.nk+1)  
      % h in gas-giant abyssal layer is set to 1.
      h = 1.;
    else  
      h = (P3(K,J,I)-P3(K-1,J,I))/(planet.g*grid_obj.dsgth(KK));

    end
  else  
    error('odd values of kk are not yet supported')
    % 
    % Interface value for h. 
    % Konor and Arakawa favor averaging instead of 
    %     h = g_inv*(P2(K+1,J,I)-P2(K,J,I))*grid_obj.dsgth_inv[kk];
    %
    %k = (kk-1)/2;
    %K=k+1;
    %if (k == 0)  
    %  % KA97 (B.14)
    %  h = get_h(planet,KK+1,J,I,TOTAL);
    %elseif (k < KHI)  
    %  h = onto_kk(planet, H3_INDEX, get_h(planet,KK-1,J,I,TOTAL),
    %                                get_h(planet,KK+1,J,I,TOTAL),KK,J,I);
    %elseif (k == KHI)  
    %  % KA97 (B.14)
    %  h = get_h(planet,KK-1,J,I,TOTAL);
    %end
  end

  if (type == DRY)  
    %
    % hdry = h-sum_i (HQ_i)
    %
    if grid_obj.nq>0
       error('Option grid_obj.np>0 is not yet supported')
    end
    %for (iq = 0; iq < grid_obj.nq; iq++)  
    %  h -= get_var(planet, grid_obj.is[iq], grid_obj.ip[iq], grid_obj.it_h, KK,J,I);
    %end
  end

end

