function s = get_sigma(pbot, p, ptop)
%
% Use a function to calculate sigma so that its definition can be 
% easily changed.
%
% NOTE: If this function is changed, then it is necessary to also modify
%       its inverse function, get_p_sigma().
%
% The value of sigma should range monotonically from 0 at the bottom of layer
% K = grid.nk to 1 at the bottom of layer K = 0.
%
% NOTE: We use log p instead of p because sigma defined with the latter stays
%       close to 0 too long with respect to height when pbot is large, such as 
%       for Venus or deep Jupiter models.
%
% (code translated from epic_funcs_diag.c)
%

  s = log(p/pbot)/log(ptop/pbot);
