
function pt_output_value = get_sounding( planet, pressure, output_name, thermo, grid_obj )
%
% Linear interpolation of t_vs_p data table.
%
% Valid output_name values: 'temperature' 
%                           'theta'
%
% For example, to get a theta(p) via linear interpolation, use 
%   get_sounding(planet,p,'theta',&theta);
%
% Interpolation uses -log(p).
%
% NOTE: If input_value is below the bottom of the data table, then the bottom
%       value of the data table is used. 
%
% NOTE: The function linint() has a float_triplet argument, even though it
%       does not use the third component, to make it easy to switch between
%       linint() and splint().
%
% (code translated from epic_funcs_diag.c)
%
if nargin<3
  error('Missing input:  planet, pressure, output_name')
end

global SIZE_DATA POST_SIZE_DATA fpara_on
 
  %if (!initialized)  
    % 
    % Input sounding data, t_vs_p: 
    %
    ntp = read_t_vs_p(planet, SIZE_DATA);

    % 
    % Allocate memory: 
    %
    pdat(1:ntp) = 0;     
    tempdat(1:ntp) = 0;  

    tdat(1:ntp) = 0;     
    thetadat(1:ntp) = 0; 

    [ntp, pdat, tempdat] = read_t_vs_p(planet,POST_SIZE_DATA);

    %
    % Set temperature data table.
    %
    %for (ki = 0; ki < ntp; ki++)  
    for ki = 0 : ntp-1
      KI=ki+1;
      tdat_tab_x(KI) = -log(pdat(KI));
      tdat_tab_x(KI) = tempdat(KI);
    end

    %
    % Set theta data table.
    %
    %for (ki = 0; ki < ntp; ki++)  
    for ki = 0 : ntp-1
      KI=ki+1;
      thetadat_tab_x(KI) = -log(pdat(KI));
      if (fpara_on)  
        % The value of fpe only depends on temperature:%
        fpara = 0.25;
        [enthalpy, fgibb, fpe, uoup] = return_enthalpy(planet, fpara, 0, tempdat(KI), thermo, grid_obj );
        fpara = fpe;
      else  
        fpara = 0.25;
      end
      thetadat_tab_y(KI) = return_theta(planet, fpara,pdat(KI), tempdat(KI), grid_obj);
    end

    %
    % From the top down, iron out negative-slope regions in theta.
    % Adjust temperature accordingly.
    %
    if (ntp-2 >= 0)  
      %for (ki = ntp-2; ki >= 0; ki--)  
      for ki = ntp-2 :-1: 0;
        KI=ki+1;
        tmp = thetadat_tab_y(KI+1);
        if (thetadat_tab_y(KI) > tmp)  
          thetadat_tab_y(KI) = tmp;
          if (fpara_on)  
            % The value of fpe only depends on temperature:%
            fpara = 0.25;
            [enthalpy, fgibb, fpe, uoup] = return_enthalpy(planet, fpara, 0, tempdat(KI), thermo, grid_obj );
            fpara = fpe;
          else  
            fpara = 0.25;
          end
          %
          % Adjust tdat.
          %
          tdat_tab_y(KI) = return_temp(planet, fpara, pdat(KI), thetadat_tab_y(KI));
        end
      end
    end 
    initialized = TRUE;
  %end 
  % End of initialization.


  %
  % Interpolate using -log(p).
  %
  x = -log(pressure);

  %
  % Restrict y(x) to not fall below bottom of data table.
  %
  if (x < tdat_tab_x(1) )  
    if strcmp(output_name,'temperature')
     pt_output_value = tdat_tab_y(1);
    elseif strcmp(output_name,'theta')
     pt_output_value = thetadat_tab_y(1);
    else  
      error(['unrecognized output_name=',output_name]);
    end
    warning(['-log(p)=' num2str(x) ' < ' num2str(tdat_tab_x(1)) '; setting ' output_name '(1)=' num2str(pt_output_value) '\n']);
  else  
    if strcmp(output_name,'temperature')
      ki              = find_place_in_table( tdat_tab_x, x );
      pt_output_value = linint(x, tdat_tab_x, tdat_tab_y, ki );
    elseif strcmp(output_name,'theta')
      ki              = find_place_in_table( thetadat_tab_x, x );
      pt_output_value = linint(x, thetadat_tab_x, thetadat_tab_y, ki );
    end
  end


