
function init_with_ref( planet, grid_obj )
% 
% Initializes P, H using grid_obj.p3_ref[K] and THETA using grid_obj.theta3_ref[K].
%
global ILO IHI JLO JHI KLO KHI THETA P3 PTOP HDRY DRY UPDATE_THETA

  %
  % Set THETA and P3. 
  %
  %for (K = 0; K <= KHI; K++)  
  %  for (J = JLOPAD; J <= JHIPAD; J++)  
  %    for (I = ILOPAD; I <= IHIPAD; I++)  
  for k = 0 : KHI
    K=k+1;
    for jj = JLO : JHI
      J=jj+1;
      for ii = ILO : IHI
        I=ii+1;
        THETA(K,J,I) = grid_obj.theta3_ref(K);
        P3(   K,J,I) = grid_obj.p3_ref(    K);
      end
    end
    % No need to apply bc_lateral() here.
  end

  K = 1;
  %for (J = JLOPAD; J <= JHIPAD; J++)  
    %for (I = ILOPAD; I <= IHIPAD; I++)  
  for jj = JLO : JHI
    J=jj+1;
    for ii = ILO : IHI
      I=ii+1;
      PTOP(J,I) = P3(K,J,I);
    end
  end
  % No need to apply bc_lateral() here.

  %
  % Set HDRY.
  %
  %for (K = KLO; K <= KHI; K++)  
  for k = KLO : KHI
    kk = 2*K;
    K=k+1;
    KK=kk+1;
    %for (J = JLOPAD; J <= JHIPAD; J++)  
      %for (I = ILOPAD; I <= IHIPAD; I++)  
    for jj=JLO:JHI
      J=jj+1;
      for ii=ILO:IHI
        I=ii+1;
        HDRY(K,J,I) = get_h(planet,kk,J,I, DRY);  % (use zero based kk)
      end
    end
  end

  %
  % Set P2, P3, H3, THETA2, etc.
  %
  set_p2etc(planet, UPDATE_THETA);

  %
  % Start with U = 0, V = 0, U_ABYSSAL = 0.
  %


