
function invertPlotColors( fig_num )

TRUE=1;  FALSE=0;

if nargin<1
   fig_num = gcf;
end


ax_id = get(fig_num,'Children');

for iax=1:length(ax_id)
   if not( strcmp( get(ax_id(iax),'Type'), 'uimenu' ))
      axes( ax_id(iax) );
   
      ax_ch = get( ax_id(iax), 'Children' );
      
      for ac=1:length(ax_ch)
        invert_colors = TRUE;
        if strcmp( get(ax_ch(ac),'Tag'), 'vector-plot' )
           invert_colors = FALSE;
        end
        if strcmp( get(ax_ch(ac),'Type'), 'text' )
           invert_colors = FALSE;
        end

        if invert_colors
   
           clear zdata
           zdata = -get( ax_ch(ac), 'ZData' );
           set( ax_ch(ac), 'ZData', zdata );

           [zmin zmax] = caxis;
           tmp_zmin=zmin; zmin=-zmax; zmax=-tmp_zmin;
           
           caxis([zmin zmax])
   
        end
   
      end

   end
end


