function makeSpinAxesSlides( write_data_dir, dln, dlt, num_revs )
%
%  function makeSpinAxesSlides( write_data_dir, dln, dlt, num_revs )
%
%   defaults:   dln      = 5.0;
%               dlt      = 0.0;
%               num_revs = 1;
%

TRUE=1;  FALSE=0;

if nargin<4
  num_revs = 1;
end
if nargin<3
  dlt = 0.0;
end
if nargin<2
  dln = 5.0;
end
if nargin<1
  error('  A write_data_dir must be specified')
end

if isdir(write_data_dir)==FALSE
   mkdir(write_data_dir);
end

delay = 0.05;  % (seconds)

%
% Longitudinal Rotation
%
figure(gcf)
slide_num=1;
for iln=1:360.0/abs(dln)*num_revs

   num_zeros = 3 - floor(log10(slide_num));
   if num_zeros>0
      z='0';
      for iz=2:1:num_zeros;
         z = [z '0'];
      end
      bmp_file = [write_data_dir slash z num2str(slide_num)];
   else
      bmp_file = [write_data_dir slash num2str(slide_num)];
   end

   unix(['rm -f ' bmp_file '.bmp ']);

   fprintf(['\tWriting bmp file ' bmp_file '.bmp\n'])
   writeFig2Bitmap( bmp_file );
   fprintf(['\tFile written \n'])

   slide_num = slide_num+1;

   camorbit(dln, dlt);

   %pause( delay );  % <-- not necessary when slides are written to bmp
end
