%fprintf('preparing to plot variables ....\n')

clear var_dims latitude longitude ILO IHI JLO JHI KLO KHI TLO THI
global ILO JLO IHI JHI KLO KHI TLO THI using_one_based_arrays

using_one_based_arrays = TRUE;

var_dims  = epic_vars(iv).dim;
ILO  = epic_vars(iv).ilo;     JLO  = epic_vars(iv).jlo;   KLO = epic_vars(iv).klo;  TLO = epic_vars(iv).tlo;
IHI  = epic_vars(iv).ihi;     JHI  = epic_vars(iv).jhi;   KHI = epic_vars(iv).khi;  THI = epic_vars(iv).thi;
if length(who( var_dims(3).name )) > 0
   eval(['latitude = ' var_dims(3).name ';'])
else
   latitude  = getNCvardata( nc_file(1).pntr, var_dims(3).name );
end
if length(who( var_dims(4).name )) > 0
   eval(['longitude = ' var_dims(4).name ';'])
else
   longitude = getNCvardata( nc_file(1).pntr, var_dims(4).name );
end

if plot_grid_only==TRUE
  color_bar_orientation=OFF;
  shading_type = 'faceted';
end

% (this coded moved to _defaults script)
%if vector_plot  &  length(epic_vars)-p2_needed-p3_needed~=2
%   error(' vector plots work require EXACTLY two variables')
%end

%
% Remap to Pressure Surfaces
%
% (moved to setExtractIndices)
%
%if remap_to_pressure_surfaces  &  it==1  &  ik==1
%  fprintf(' remapping data to pressure surfaces .....');
%  processEpicVarsForPressureCoord;
%
%  fprintf('done\n');
%  num_plot_vars = length(vars_to_plot) - p2_needed - p3_needed;
%end

%
% Make data periodic
%
if make_x_data_periodic == TRUE
   epic_vars(iv).data(:,:,:,IHI+1) = epic_vars(iv).data(:,:,:,1);
   longitude(IHI+1) = 2*longitude(IHI) - longitude(IHI-1);
   IHI = IHI+1;
   %epic_vars(iv).ihi = IHI;
end


%
% Set figure size and position
%
Xlower = [longitude(ILO+IOFFSET())  latitude(JLO+JOFFSET())];
Xupper = [longitude(IHI+IOFFSET())  latitude(JHI+JOFFSET())];
Xlen = abs(Xupper - Xlower);

if length(who('alter_fig_width_for_globe'))
   if ( alter_fig_width_for_globe )
      Xlen(1) = Xlen(2) * 11.1 / 6.4;
   end
end


if ( Xlen(1) > Xlen(2) )
   fig_size = [ fig_pos(1)  fig_pos(2)  fig_width*Xlen(1)/Xlen(2)  fig_width ];
else
   fig_size = [ fig_pos(1)  fig_pos(2)  fig_width  fig_width*Xlen(2)/Xlen(1) ];
end


if length(who('override_fig_orientation'))
   if length(override_fig_orientation) ~= 4
      error('override_fig_orientation must be of length 4');
   end
   fig_size = override_fig_orientation;
   Xlen(1) = fig_size(3);
   Xlen(2) = fig_size(4);
end




%%
%% Preprocess Data for Zonal Reduction Plots
%%
if  it==1  &  ik==1
  if zonal_anomoly_plot_on | zonal_max_plot_on  |  zonal_average_plot_on  |  longitude_slice_plot 
    clear grid_obj itmp
    % make meridional velocities zero at poles
    if length(who('value_at_poles'))  &  epic_vars(iv).name=='v'
     %for it=1:length(extract_it), if extract_it(it)<=length( var(nc_file,'time') )
     %  for ik=1:length(extract_ik), if extract_ik(ik)<=length( var(nc_file,'sigmatheta_u') )
     N = size( epic_vars(iv).data );  
     clear new_data
     for it2=1:N(1)
       for ik2=1:N(2)
          plot_data(:,:) = epic_vars(iv).data(it2,ik2,:,:);
          [plot_data new_latitude] = addValuesAtPoles( plot_data, latitude, value_at_poles );
  %size(plot_data)
          new_data(it2,ik2,:,:) = plot_data(:,:);
          clear plot_data
       end %, end
     end %, end
     epic_vars(iv).data = [];
     epic_vars(iv).data = new_data;   clear new_data
     latitude           = new_latitude;
    end
    % adjust indices
    extract_ik = 1;
    ILO  = epic_vars(iv).jlo;     JLO  = epic_vars(iv).klo;   KLO = 1;  
    IHI  = epic_vars(iv).jhi;     JHI  = epic_vars(iv).khi;   KHI = 1; 
  end
end



