
function printToFile( filename, format, dpi )
%
% function printToFile( filename, format, dpi )
%
%   Routine writes the current figure to a file named [filename '.<format>'].
%
%   Valid entries for input variable format are:
%                             'ps'
%                             'psc'
%                             'ps2'
%                             'psc2'
%
%                             'eps'
%                             'epsc'     (default)
%                             'eps2'
%                             'epsc2'
%
%                             'ill'
%                             'pdf'
%
%                             'jpeg'
%                             'tiff'
%                             'png'
%                             'bmp'
%   
%   For more information on the above file formats, see "help print"
%    and "help private/ghostscript".
%
%   see also:  writeFig2Bitmap()
%

TRUE=1; FALSE=0;
if nargin<1
  error(' A filename must be specified:  printToFile( filename, format, dpi )')
end

if nargin<2
  format = 'epsc';
end

if nargin<3
  dpi = -1;
elseif ischar(dpi)
  error(' Input argument "dpi" must be a number.')
end


if strcmp( format, 'screen' ) 

  writeFig2Bitmap(filename)

else

  ivf=1;
  valid_format(ivf).name = 'ps';       ivf=ivf+1;
  valid_format(ivf).name = 'psc';      ivf=ivf+1;
  valid_format(ivf).name = 'ps2';      ivf=ivf+1;
  valid_format(ivf).name = 'psc2';     ivf=ivf+1;
  valid_format(ivf).name = 'eps';      ivf=ivf+1;
  valid_format(ivf).name = 'epsc';     ivf=ivf+1;
  valid_format(ivf).name = 'eps2';     ivf=ivf+1;
  valid_format(ivf).name = 'epsc2';    ivf=ivf+1;
  valid_format(ivf).name = 'ill';      ivf=ivf+1;
  valid_format(ivf).name = 'jpeg';     ivf=ivf+1;
  valid_format(ivf).name = 'tiff';     ivf=ivf+1;
  valid_format(ivf).name = 'png';      ivf=ivf+1;
  valid_format(ivf).name = 'pdf';      ivf=ivf+1;
  valid_format(ivf).name = 'bmp';      ivf=ivf+1;
  
  valid_format_found = FALSE;
  for ivf=1:length(valid_format)
    if strcmp( format, valid_format(ivf).name )
      valid_format_found = TRUE;
    end
  end
  
  if not(valid_format_found)
    if ischar( format )
      error([' format = "' format '" is not supported.']);
    else
      error([' format = "' num2str(format) '" is not supported.']);
    end
  end
  
  if strcmp( format, 'jpeg' )
    format = [format '100'];
  end
  if strcmp( format, 'tiff' )  
    format = [format 'nocompression'];
  end
  if strcmp( format, 'bmp' )
    format = [format '16m'];
  end
  
  
  
  figure(gcf);
  set(gcf,'PaperPositionMode','auto');
  
  %print( ['-f' num2str(gcf)],  '-depsc',  filename );
  
  if dpi == -1  % (use default resolution)
    print( ['-f' num2str(gcf)],  ...
           ['-d' format      ],  ...
           filename );
  else
    print( ['-f' num2str(gcf)],  ...
           ['-d' format], ...
           [ '-r' num2str(dpi) ],  ...
           filename );
  end

end

