%fprintf('processing data for plotting ....\n')

   buldge_factor = 0.95;  % (used for spherical coord plots to buldge the equator slightly)

   x_min   =  10e10;      x_max = -10e10;
   y_min   =  10e10;      y_max = -10e10;
   var_min =  10e10;    var_max = -10e10;


         clear plot_x plot_y tmp_data plot_data

         plot_x = longitude;
         plot_y = latitude;

         % Remap to Pressure Surfaces
         %if remap_to_pressure_surfaces
         %  processEpicVarsForPressureCoord;
         %end

         % PREPARE DATA  --  ZONAL ANOMOLY
         if zonal_anomoly_plot_on
            return_anomoly=3;
            epic_vars(iv) = getZonalReducedEpicData( epic_vars(iv), return_anomoly  );
            plot_x = latitude;
            if length(who('override_plot_y'))
               plot_y = override_plot_y;
            elseif strcmp( zonal_anomoly_plot, 'surf' )
               if remap_to_pressure_surfaces
                 plot_y = press_plot_y;
               else
                 plot_y = getNCvardata( nc_file(1).pntr, var_dims(2).name );
               end
            else
               plot_y = [-50.0 50.0];
            end

         end

         % PREPARE DATA  --  ZONAL MAX
         if zonal_max_plot_on
            return_max=2;
            epic_vars(iv) = getZonalReducedEpicData( epic_vars(iv), return_max );
            plot_x = latitude;
            if length(who('override_plot_y'))
               plot_y = override_plot_y;
            elseif strcmp( zonal_max_plot, 'surf' )
               if remap_to_pressure_surfaces
                 plot_y = press_plot_y;
               else
                 plot_y = getNCvardata( nc_file(1).pntr, var_dims(2).name );
               end
            else
               plot_y = [-50.0 50.0];
            end

         end

         % PREPARE DATA  --  ZONAL AVERAGE
         if zonal_average_plot_on
            epic_vars(iv) = getZonalReducedEpicData( epic_vars(iv) );
            plot_x = latitude;
            if length(who('override_plot_y'))
               plot_y = override_plot_y;
            elseif strcmp( zonal_average_plot, 'surf' )
               if remap_to_pressure_surfaces
                 plot_y = press_plot_y;
               else
                 plot_y = getNCvardata( nc_file(1).pntr, var_dims(2).name );
               end
            else
               plot_y = [-50.0 50.0];
            end

         end

         % PREPARE DATA  --  LONGITUDE SLICE
         if longitude_slice_plot_on
            longitude_slice_var = getLongitudeSliceEpicData( epic_vars, iv, longitude, longitude_slice );
            epic_vars(iv).data = [];
            epic_vars(iv) = longitude_slice_var(iv);  clear longitude_slice_var
            plot_x = latitude;
            if length(who('override_plot_y'))
               plot_y = override_plot_y;
            elseif strcmp( longitude_slice_plot, 'surf' )
               if remap_to_pressure_surfaces
                 plot_y = press_plot_y;
               else
                 plot_y = getNCvardata( nc_file(1).pntr, var_dims(2).name );
               end
            else
               plot_y = [-50.0 50.0];
            end

         end

         % GET DATA FOR PLOTTING
         x_max = max( x_max, max( plot_x ) );   
         y_max = max( y_max, max( plot_y ) );   
   
         x_min = min( x_min, min( plot_x ) );   
         y_min = min( y_min, min( plot_y ) );   
   
         plot_data(:,:) = epic_vars(iv).data( it, ik, :, : );
         %fprintf(' max, min of plot_data = %e, %e\n', max(max(plot_data)), min(min(plot_data)) );


         % CONVERT PRESSURE UNITS
         if convert_Pa_to_mbar  &  strcmp( epic_vars(iv).units, 'Pa' )
           scale_data = scale_data * 0.01;
           epic_vars(iv).units = 'mb';
         end
         if convert_mbar_to_Pa  &  strcmp( epic_vars(iv).units, 'mb' )
           scale_data = scale_data * 100.0;
           epic_vars(iv).units = 'Pa';
         end


         % SCALE DATA
         plot_data = plot_data .* scale_data;
         epic_vars(iv).data( it,ik,:,:) = epic_vars(iv).data( it,ik,:,:) .* scale_data;
         if vector_plot
            epic_vars(iv+1).data( it,ik,:,:) = epic_vars(iv+1).data( it,ik,:,:) .* scale_data;
         end
         %fprintf(' max, min of scaled plot_data = %e, %e\n', max(max(plot_data)), min(min(plot_data)) );


         % INTERPOLATE COARSE DATA
         if length(who('min_display_resolution'))  &  not(vector_plot)
            mc_res = min_display_resolution(1);
            if length(plot_x) < mc_res
              fplot_x = linspace( plot_x(1), plot_x(length(plot_x)), mc_res );
            else
              fplot_x = plot_x;
            end
            mc_res = min_display_resolution(length(min_display_resolution));
            if length(plot_y) < mc_res
              fplot_y = linspace( plot_y(1), plot_y(length(plot_y)), mc_res );
            else
              fplot_y = plot_y;
            end

            [coarse_grid_x, coarse_grid_y] = meshgrid(  plot_x,  plot_y );
            [  fine_grid_x,   fine_grid_y] = meshgrid( fplot_x, fplot_y );
            fplot_data = interp2(coarse_grid_x, coarse_grid_y, plot_data, ...
                                   fine_grid_x,   fine_grid_y, 'cubic' );

            clear plot_data plot_x plot_y
            plot_x    = fplot_x;
            plot_y    = fplot_y;
            plot_data = fplot_data;
            clear fplot_x fplot_y fplot_data coarse_grid_x coarse_grid_y fine_grid_x fine_grid_y
         end


         % VECTOR PLOT
         if vector_plot

            getVectorPlotData

            % display vector plot
            clear latitude longitude plot_x plot_y
            latitude    = u_latitude;
            longitude   = u_longitude;
            plot_x = longitude;
            plot_y = latitude;

            if spherical_coord_plot == FALSE
              vhandle = quiver( longitude, latitude, u_plot_data, v_plot_data, vector_arrow_scale, 'k-' );
              set(vhandle,'Tag','vector-plot');
            end

         end

         % SET VALUES AT THE POLES
         if length(who('value_at_poles'))==TRUE   &  vector_plot==FALSE  ...
            &  zonal_anomoly_plot_on==FALSE & zonal_max_plot_on==FALSE  &  zonal_average_plot_on==FALSE  ...
            & longitude_slice_plot_on==FALSE & topography_plot==FALSE
            [plot_data plot_y] = addValuesAtPoles( plot_data, latitude, value_at_poles );
            latitude = plot_y;
         end

         % LOGARITHMIC OPTION
         if  length(who('logarithmic_plot')) > 0   &  not( cart_line_plot )
            if logarithmic_plot
               min_log_data = 0.1;
               if length(who('min_logarithmic_limit')) == 1
                  min_log_data = min_logarithmic_limit;
               end
               plot_data = log10( max(abs(plot_data), min_log_data) );

               %pos_neg   = sign(plot_data);
               %plot_data = log10( max(abs(plot_data), min_log_data) ) .* pos_neg;

               plot_data = plot_data .* scale_data_after_log;
            end
         end
        

         hold on

	 % SPHERICAL COORDINATE PLOT
	 if spherical_coord_plot
            getSphericalPlotData

            %size(sphere_plot_x), size(sphere_plot_y), size(sphere_plot_z), size(plot_data)
            if vector_plot
              vhandle=quiver3( sphere_plot_x, sphere_plot_y, sphere_plot_z, ...
                               sphere_u_data, sphere_v_data, sphere_w_data, ...
                               vector_arrow_scale, 'k-' );
              set(vhandle,'Tag','vector-plot');

              hold on
              bg_surf = sphere_u_data;
              bg_surf(:,:) = 1.0;
              shandle = surf( .98*sphere_plot_x, .98*sphere_plot_y, .98*sphere_plot_z, bg_surf );
              %colormap([.5 .5 .5]);  % gray
              %colormap([1 .5 .15])   % orange

            elseif topography_plot
              Rmin = 0.88;
              Rmax = 1.0;
              max_topo       = max(max(plot_data));
              change_in_topo = max_topo - min(min(plot_data));
              for jj=JLO:JHI
                 J=jj+JOFFSET();
                 for ii=ILO:IHI
                    I=ii+IOFFSET();
                    topo_alter = ( (Rmax-Rmin)*(plot_data(J,I)-max_topo) + change_in_topo ) / change_in_topo;
                    sphere_plot_x(J,I) = sphere_plot_x(J,I) * topo_alter;
                    sphere_plot_y(J,I) = sphere_plot_y(J,I) * topo_alter;
                    sphere_plot_z(J,I) = sphere_plot_z(J,I) * topo_alter;
                 end
              end
              shandle = surf( sphere_plot_x, sphere_plot_y, sphere_plot_z, plot_data );

            else
              shandle = surf( sphere_plot_x, sphere_plot_y, sphere_plot_z, plot_data );
            end

         end
         %length( plot_x ), length( plot_y ), size(plot_data)

         % SURFACE PLOT
         if cart_surf_plot
            shandle = surf( plot_x, plot_y, plot_data );
            if zonal_anomoly_plot_on | zonal_max_plot_on | zonal_average_plot_on | longitude_slice_plot_on
              if k_sigma_line ~= -1
                hold on
                phandle = plot( plot_x, plot_data(k_sigma_line,:)', 'k-.' );
                set(phandle, 'ZData', 1.1*get(phandle,'YData') );
              end
            end
         end



         % LINE PLOT
         if cart_line_plot
            line_plot_data = plot_data;

            %phandle = semilogy( plot_x, line_plot_data' );
            phandle = plot( plot_x, line_plot_data' );
            box on

            if cart_reverse_line_plot
               view(0,-90);
            end

            if logarithmic_plot
               %yaxis_label = ['Log( ' yaxis_label ' )'];
               set(gca, 'YScale', 'log');
            end

            yaxis_label = epic_vars(iv).units;
            y_min = min(min(line_plot_data));  y_max = max(max(line_plot_data));
            if (y_max-y_min<1.e-30), y_min=y_min-1.e-30; y_max=y_max+1.e-30; end
            if y_min>0,  y_min=y_min*0.95;  else,  y_min=y_min*1.05; end
            if y_max>0,  y_max=y_max*1.05;  else,  y_max=y_max*0.95; end
	 end
         

         % GRID ONLY OPTION
         if length(who('plot_grid_only'))
            if plot_grid_only==TRUE
               colormap([1 1 1])
            end
         end

         %gcolor = eval(['grid_color_level_' num2str(ln)]);
         %set(shandle, 'EdgeColor', gcolor);


         % CONTOUR PLOT
         if contour_plot

            % set contour plot attributes
            contour_type = 0;
            if length(who('contour_plot_type')) == 1
               contour_type = contour_plot_type;
            end

            num_lines = 10;
            if length(who('num_contour_lines')) == 1
               num_lines = num_contour_lines;
            end

            if length(who('contour_lines'))
              cont_lines = contour_lines;
            else
              cont_lines = num_lines;
            end
      
            % display contour plot 
            hold on
            if contour_type == 0
               %[cs chan]=contour(plot_x, plot_y, plot_data, cont_lines);
               [cs chan]=contourpm(plot_x, plot_y, plot_data, cont_lines);
            
            elseif contour_type == 1
               %[cs chan]=contourf(plot_x, plot_y, plot_data, cont_lines);
               [cs chan]=contourfpm(plot_x, plot_y, plot_data, cont_lines);
            
            end

            % add labels to contours
            if length(cont_lines)>1
              if length(who('contour_lines_label'))
                cont_lines_label = contour_lines_label;
              else
                cont_lines_label = cont_lines;
              end
      
              if not( strcmp(cont_lines_label, 'none') )
                clabel(cs, chan, cont_lines_label);

                % reset the negative contour lines since clabel makes them all solid
                cont_ids = get(chan, 'Children' );
                for icd=1:length(cont_ids)
                  if isfield( get(cont_ids(icd)), 'FaceVertexCData' )
                    cont_val = get(cont_ids(icd), 'FaceVertexCData' );
                    if cont_val < 0
                      if contour_type==0
                        set(cont_ids(icd), 'LineStyle', ':');
                      elseif contour_type==1
                        set(cont_ids(icd), 'LineStyle', '--');
                      end
                    end
                  end
                end

              end
            end

            box on

            if zonal_anomoly_plot_on | zonal_max_plot_on | zonal_average_plot_on | longitude_slice_plot_on
              if k_sigma_line ~= -1
                hold on
                phandle = plot( plot_x, plot_data(k_sigma_line,:)', 'k-.' );
                set(phandle, 'ZData', 1.1*get(phandle,'YData') );
              end
              if remap_to_pressure_surfaces
                set(gca, 'YScale', 'log');
                view(0,-90);
              end
            end
         end



         % GET MAX AND MIN OF VARIABLE
         pb_var_max = max( max( plot_data ) );
         pb_var_min = min( min( plot_data ) );

         var_max = max( var_max, pb_var_max );
         var_min = min( var_min, pb_var_min );




