
%
% NOTE:  The press_plot_y variable is ambiguous as defined here.  To avoid confusion,
%         do NOT plot interface and layer variables at the same time.
%

for iv2=1:num_plot_vars + vector_plot
  press_units = ' ';

  if strfind( vars_to_plot(iv2).name, '3' )   |   strcmp( vars_to_plot(iv2).name, 'theta' )
    [epic_vars, press_plot_y] = remapEpicVarToNewSurfaces( epic_vars, nc_file(1).pntr,        ...
                                                       vars_to_plot(iv2).name, 'p3', 'p3', ...
                                                       FALSE, 'all' );
    for iev=1:length(epic_vars)
      if strcmp(epic_vars(iev).name, 'p3')
        press_units = epic_vars(iev).units;

        if convert_Pa_to_mbar  &  strcmp(press_units, 'Pa')
          press_plot_y = press_plot_y * 0.01;
        end
        if convert_mbar_to_Pa  &  strcmp(press_units, 'mb')
          press_plot_y = press_plot_y * 100;
        end

      end
    end
  else
    [epic_vars, press_plot_y] = remapEpicVarToNewSurfaces( epic_vars, nc_file(1).pntr,        ...
                                                       vars_to_plot(iv2).name, 'p2', 'p2', ...
                                                       FALSE, 'all' );
    for iev=1:length(epic_vars)
      if strcmp(epic_vars(iev).name, 'p2')
        press_units = epic_vars(iev).units;

        if convert_Pa_to_mbar  &  strcmp(press_units, 'Pa')
          press_plot_y = press_plot_y * 0.01;
        end
        if convert_mbar_to_Pa  &  strcmp(press_units, 'mb')
          press_plot_y = press_plot_y * 100;
        end

      end
    end
  end
end

  
%if convert_Pa_to_mbar  &  strcmp(press_units, 'Pa')
%  press_plot_y = press_plot_y * 0.01;
%end
%
%if convert_mbar_to_Pa  &  strcmp(press_units, 'mb')
%  press_plot_y = press_plot_y * 100;
%end


