

   % set color map
   caxis_set = FALSE;
   if not(contour_plot)  

      if ( use_auto_color_map == TRUE )
         zmin = var_min;  zmax = var_max;
      end
      if ( abs(zmax-zmin)<100*eps )
        zmax = zmax*(1.0 + 10^-10);  
        zmin = zmin*(1.0 - 10^-10);  
      end
      caxis([ zmin zmax ]);
      caxis_set = TRUE;

   else
      using_bw_contour = TRUE;
      if length(who('contour_plot_type')) == 1
         if contour_plot_type ~= 0
            using_bw_contour = FALSE;
         end
      end
      if using_bw_contour == TRUE
         colormap([0 0 0]);
         zmin=var_min;
         zmax=var_max;
      else 
         if ( use_auto_color_map == TRUE )
            zmin = var_min;  zmax = var_max;
         end
         if ( abs(zmax-zmin)<10*eps )
           zmax = zmax + 10*eps;
           zmin = zmin - 10*eps;
         end
         caxis([ zmin zmax ]);
         caxis_set = TRUE;
      end
   end

   if length(who('colormap_type'))
      cm_type = colormap_type;
      if strcmp(colormap_type, 'light-gray')
        cm_type = 'gray';
        if caxis_set
          caxis([(zmin-(zmax-zmin)/3)  zmax]);
        end
      end
      colormap( cm_type );
   end


   % add esacpe characters to title if necessary
   %for ln=1:nlevels
   %   if ( hierarchy.level(ln).num_pboxes > 0 ) 
   %      ptitle = hierarchy.level(ln).pbox(1).var( v ).name;
   %   end
   %end
   ptitle = epic_vars(iv).name;
   for ch=length(ptitle):-1:1
      %if ( ptitle(ch)=='_'  |  ptitle(ch)=='^' )
      if ( ptitle(ch)=='_' )
         if (ch==1)
           ptitle = [ '\' ptitle(ch : length(ptitle) ) ];
         else    
           ptitle = [ ptitle(1:ch-1) '\' ptitle(ch:length(ptitle)) ];
         end
      end  
   end
   if length(who('Title'))
      ptitle = Title;
   end
   title( ptitle );

   % determine if plot is spherical coord or cart coord
   plot_cart = TRUE;
   if ( length( who('spherical_coord_plot') ) == 1 ) 
      if ( spherical_coord_plot == TRUE ) 
          plot_cart = FALSE;
      end
   end

   % no new figures for SCALAR-MULTI-LAYER
   if strcmp(plot_type,'SCALAR-MULTI-LAYER')
      generate_new_figures = FALSE;
      hold on
      view(3)
   end

   % call scripts specifically for cartesian or spherical 
   if ( plot_cart == TRUE  |  contour_plot~=OFF)
      processPrettyGraphics_cart
   else
      processPrettyGraphics_sphr
   end

   

