   %
   % Expand axis to occupy most of figure
   %
   if ( maximize_display == FALSE ) 
      apos = get( gca, 'Position' );
      fpos = get( gcf, 'Position' );

      disp_buf = 0.90;
      %disp_buf = 1.0;
      if length(who('fill_axis_in_figure'))>0
         disp_buf = fill_axis_in_figure;
      end

      if ( Xlen(1)>Xlen(2) )
         apos(4) = disp_buf * Xlen(2)/Xlen(1) * fpos(3)/fpos(4);
         apos(3) = disp_buf ;
      else
         apos(3) = disp_buf * Xlen(1)/Xlen(2) * fpos(4)/fpos(3);
         apos(4) = disp_buf ;
      end
      apos(1) = 0.50*(1-apos(3));
      apos(2) = 0.50*(1-apos(4));

      if length(who('left_right_justify'))==1
         apos(1) = left_right_justify*(1-apos(3));
      end

      if length(who('bottom_top_justify'))==1
         apos(2) = bottom_top_justify*(1-apos(4));
      end

 
      % place off center to make room for axis labels
      label_shift = [1.50 1.6];
      apos(2) = apos(2) * label_shift(2);
      apos(1) = apos(1) * label_shift(1);

      set( gca, 'Position', apos );


      % make room for title
      if length(who('display_title'))
         if display_title == TRUE
            title_buffer = 1.05;

            new_height = title_buffer * fpos(4);
            apos(4) = apos(4) * fpos(4) / new_height;
            fpos(4) = new_height;

            set(gcf, 'Position', fpos );
            set(gca, 'Position', apos );
         end
      end

   end

   if length(who('override_axis_orientation'))==1
      if length(override_axis_orientation) ~= 4
         error('override_axis_orientation must have length 4');
      end
      set(gca, 'Position', override_axis_orientation);
   end


   %
   % color bar
   %
   hcbar_gap = 0.0; vcbar_gap = 0.0;
   if ( (color_bar_orientation==1 | color_bar_orientation==2)   ) %&  contour_plot_level==OFF ) 

       addColorBarToFigure
   end 


   %
   % Modify MATLAB's default axis settings
   %
   %axis_buf = 0.2;
   axis_buf = [0.05 0.02];
   I = ILO + IOFFSET();  J = JLO + JOFFSET();
   dx(1:2) = [ longitude(I+1)-longitude(I), latitude(J+1)- latitude(J) ];
   if cart_line_plot 
     if logarithmic_plot
       dx(2)=0.;
     else
       dx(2) = abs(0.5*(y_min+y_max));
     end
   end

   axis([(x_min-axis_buf(1)*dx(1)) (x_max+axis_buf(1)*dx(1)) (y_min-axis_buf(2)*dx(2)) (y_max+axis_buf(2)*dx(2)) ])
   if length(who('override_axis_limits')) > 0
      axis( override_axis_limits );
   end

   if ( maximize_display == TRUE ) 
      %set( gca, 'Position', [0.005, 0.005, 0.99, 0.99] );
      set( gca, 'Position', [0.005, 0.005+vcbar_gap/(1+vcbar_gap), 0.99/(1+hcbar_gap), 0.99/(1+vcbar_gap)] );
   end

   axis_background_color = [0 0 0];
   if ( contour_plot==TRUE  |  vector_plot==TRUE ) 
      set( gca, 'Color'   , [1 1 1] );
   end

   %
   % Force contour lines to show up.  This approach is figity and does not always work!
   %
   if contour_plot 
     if contour_type==1
       ch=findobj('LineColor',[0 0 0]);
       for ich=1:length(ch)
         set(ch(ich),'LineColor',[1 1 1]);
         set(ch(ich),'LineColor',[0 0 0]);
       end
     end
   end

   set( gcf, 'Color'   , background_color );
   set( gca, 'Color'   , background_color );

   if ( (disp_axis == FALSE & contour_plot == OFF) |  maximize_display == TRUE)
      %axis off
      set( gca, 'XTick', [] );
      set( gca, 'YTick', [] );
   else
      %if cart_reverse_line_plot
      %   ytick_tmp = get(gca,'YTick');
      %   ytick_tmp = -ytick_tmp ;
      %   set(gca,'YTickLabel',ytick_tmp );
      %   clear ytick_tmp
      %end
      
      if ( length(who('xtick'))==1 )
         set(gca,'XTick',xtick);
      end
         
      if ( length(who('ytick'))==1 )
         set(gca,'YTick',ytick);
      end
   
      if ( length(who('xticklabel'))==1 )
         set(gca,'XTickLabel',xticklabel);
      end
         
      if ( length(who('yticklabel'))==1 )
         set(gca,'YTickLabel',yticklabel);
      end

      if length(who('XLabel'))
         xaxis_label = XLabel;
      end
      if length(who('YLabel'))
         yaxis_label = YLabel;
      end

      %if logarithmic_plot  &  not(cart_line_plot)
      %   yaxis_label = ['Log( ' yaxis_label ' )'];
      %end

      xlabel( xaxis_label );
      ylabel( yaxis_label );

   end


   %
   % Reset Y-Axis for pressure remapped plots
   %
   % NOTE:  This must be done after calls to axis() and addColorBar() to 
   %         avoid internal Matlab gliches.
   %
   if zonal_anomoly_plot_on | zonal_max_plot_on | zonal_average_plot_on | longitude_slice_plot_on
     if remap_to_pressure_surfaces
       set(gca, 'YScale', 'log');
       view(0,-90);
     end
   end


   %
   % set shading 
   %
   % NOTE: apply to surface plots only!  Problems occur with contour plots otherwise.
   %
   if length( who( 'shading_type' ) )   &  length(who('shandle'))
      eval(['shading ' shading_type])
   end

   % set line colors
   if cart_line_plot  
      cm = getEpicLinePlotColorMap( 'bgr' );
      line_ids = get(gca,'Children');
      for il=1:length(line_ids)
         color = getEpicLineColor( il, length(line_ids), cm );
         set( line_ids(il), 'Color', color );
      end
      if ( k_sigma_line ~= -1 )
        %set( line_ids(k_sigma_line), 'LineStyle', '-.' );
        set( line_ids(k_sigma_line), 'LineStyle', k_sigma_line_style );
      end
   end

   % set topography figure
   if topography_plot
    shading interp
    colorbar off
    colormap([1 .5 .15])  % color for Venus

    extra_lat = 35;
    yL = -90 - extra_lat;
    yH =  90 + extra_lat;

    flatten     = 0.5;                          % <-- increase value to flatten more
    fake_height = zmax + flatten*(zmax-zmin);  
    %fake_height = - fake_height;

    phanL = patch( [-180 180 180 -180], ...
                   [ yL  yL -90 -90], ...
                   [fake_height fake_height fake_height fake_height], ...
                   background_color );

    phanH = patch( [-180 180 180 -180], ...
                   [  90  90 yH   yH], ...
                   [fake_height fake_height fake_height fake_height], ...
                   background_color );

    set(phanL, 'FaceAlpha', 0);
    set(phanL, 'EdgeAlpha', 0);
    set(phanH, 'FaceAlpha', 0);
    set(phanH, 'EdgeAlpha', 0);

    axis([-180 180 yL yH ])
    %axis off                                   % "axis off" screws up the lighting for some reason.
    set(gca,'XColor', background_color)         % reset the color of the axes as a work around.
    set(gca,'YColor', background_color)
    set(gca,'ZColor', background_color)
   
    set(gca,'Position', [0.01 0.05 0.99 1.0]);  % this setting seems to center the axes best
    %set(gca,'Position', [0.01 -0.15 0.99 1.0]);  

    light
    material dull
    lighting phong

    cameramenu
    view(-10,20)
    light
    light

     %spin_axes( 5.0, 0.0, num_rotations );
   end

   % set multi-layer figure
   if multi_layer_plot
      colorbar off
      colormap([1 .5 .15])  % color for Venus

      shading interp
      material dull

      layer_is_opaque=FALSE;
      for ioplay = 1:length(opaque_ik)
         if opaque_ik(ioplay) == extract_ik(ik)
            layer_is_opaque=TRUE;
         end
      end

      if layer_is_opaque==FALSE
        set(shandle, 'FaceAlpha', 1-see_through);
        set(shandle, 'EdgeAlpha', 1-see_through);
      end

      if ik==length(extract_ik)

      extra_lat = 35;
      yL = -90 - extra_lat;
      yH =  90 + extra_lat;

      flatten     = 1.5;                          % <-- increase value to flatten more
      fake_height = zmax + flatten*(zmax-zmin);  

      phanL = patch( [-180 180 180 -180], ...
                     [ yL  yL -90 -90], ...
                     [fake_height fake_height fake_height fake_height], ...
                     background_color );

      phanH = patch( [-180 180 180 -180], ...
                     [  90  90 yH   yH], ...
                     [fake_height fake_height fake_height fake_height], ...
                     background_color );

      set(phanL, 'FaceAlpha', 0);
      set(phanL, 'EdgeAlpha', 0);
      set(phanH, 'FaceAlpha', 0);
      set(phanH, 'EdgeAlpha', 0);

      axis([-180 180 yL yH ])
      %axis off                                   % "axis off" screws up the lighting for some reason.
      set(gca,'XColor', background_color)         % reset the color of the axes as a work around.
      set(gca,'YColor', background_color)
      set(gca,'ZColor', background_color)
     
      set(gca,'Position', [0.01 0.05 0.99 1.0]);  % this setting seems to center the axes best

      lighting phong

      cameramenu
      view(-40,20)
      %view(-90,-1)
      light
      light
      end

   end

