
   % make figure square
   fpos = get( gcf, 'Position' );
   disp_buf = 0.75;
   if ( fpos(3) > fpos(4) ) 
      fpos(3) = fpos(4);
   else
      fpos(4) = fpos(3);
   end
   set( gcf, 'Position', fpos );
   view(-90,0);

   %
   % color bar
   %
   hcbar_gap = 0.0; vcbar_gap = 0.0;
   if ( (color_bar_orientation==1 | color_bar_orientation==2)  &  contour_plot==OFF ) 

      addColorBarToFigure
   end  


%   % draw patches
%   if ( draw_patch_boundaries == TRUE ) 
%      %height = 1.006;
%      height = 1.01;
%      for ln=1:length(hierarchy.level)
%         pcolor = eval(['patch_color_level_' num2str(ln)]);
%
%         if (pcolor ~= 'none')
%            draw_perimeter_only = FALSE;
%            if length(who('remove_patch_overlaps')) == 1
%              draw_perimeter_only = remove_patch_overlaps;
%            end
%
%            if draw_perimeter_only == TRUE
%               draw_level_perimeter_sphr( hierarchy.level(ln), height, pcolor, fig_num, buldge_factor );
%
%            else
%               for p = 1:1:hierarchy.level(ln).num_patch_boxes;
%                  patch_box = hierarchy.level(ln).patch_box(p);
%                  patch_box.Xlower(1) = max( patch_box.Xlower(1), x_min );
%                  patch_box.Xlower(2) = max( patch_box.Xlower(2), y_min );
%                  patch_box.Xupper(1) = min( patch_box.Xupper(1), x_max );
%                  patch_box.Xupper(2) = min( patch_box.Xupper(2), y_max );
%                  draw_patch_sphr( patch_box, height, pcolor, fig_num, buldge_factor );
%               end
%            end
%
%         end
%
%      end
%   end


   %
   % Modify MATLAB's default axis settings
   %
   if ( maximize_display == TRUE ) 
      title(' ')
      set( gca, 'Position', [0.005, 0.005+vcbar_gap/(1+vcbar_gap), 0.99/(1+hcbar_gap), 0.99/(1+vcbar_gap)] );
   end
   axis([-1.01 1.01 -1.01 1.01 -1.01 1.01])

   set( gcf, 'Color'   , background_color );
   set( gca, 'Color'   , background_color );
   %set( gcf, 'Color', [1 1 1] );

   % set shading
   if length( who( 'shading_type' ) ) == 1
      eval(['shading ' shading_type])
   end

   % set topography figure
   if topography_plot  |  vector_plot
      shading interp
      colorbar off
      colormap([1 .5 .15])

      %light
      material dull
      lighting phong

      %view(-90,20)
      lightangle(130,70)

   end
   if topography_plot 
      set( gca, 'XColor', background_color );
      set( gca, 'YColor', background_color );
      set( gca, 'ZColor', background_color );
   else
      axis off
   end

   % increase head size of arrows
   if vector_plot
      v_id = findobj( 'Type', 'hggroup' );
      a_id = get( v_id(1),  'Children' );
      head_id = a_id(2);
      set(head_id, 'LineWidth', 2.0);
   end

   cameramenu

   % rotate figure
   spin_axes( 5.0, 0.0, num_rotations );

