function [ntp, pdat, tdat] = read_t_vs_p( planet, portion )
%
% (code translated from epic_funcs_io.c)
%


%SIZE_DATA = 1;  % (defined in epic.h)
global SIZE_DATA

if nargin<2
   portion = 0;
end
 

   EPIC_PATH = getEpicPath();

   if strcmp(planet.name,'triton') 
     % For Triton, use aux_a to flag which T(p) data is used %
     if (portion == SIZE_DATA)  
       aux_a = input('Use Strobel[0] or Olkin[1] T(p)? \n');
     end
     if (aux_a == 0)  
       infile = [ EPIC_PATH '/data/' planet.name '/t_vs_p.' planet.name '.strobel' ];
     elseif (aux_a == 1)  
       infile = [ EPIC_PATH '/data/' planet.name '/t_vs_p.' planet.name '.olkin' ];
     else  
       error('unrecognized T(p) flag for Triton');
     end
   else  
     infile = [EPIC_PATH '/data/' planet.name '/t_vs_p.' planet.name ];
   end
   % Open t_vs_p file %
   t_vs_p = fopen(infile,'r');
   if (t_vs_p == -1)  
     error(['Cannot open file ' infile]);
   end

   % Skip over 6-line header: %
   %for (nn = 0; nn < 6; nn++)  
     %fgets(header,N_STR,t_vs_p);  
   for nn = 1 : 6
     fgetl(t_vs_p);  
   end
   % input number of data points %
   %fscanf(t_vs_p,'%d',&ntp); 
   ntp = str2num( fgetl(t_vs_p) );
 
   if length(ntp)~=1
      error('More than 1 value for ntp.  (check t_vs_p file format)')
   end

 
   if (portion == SIZE_DATA)  
     fclose(t_vs_p);
     return ;   % (ntp);
   end

   % 
   % Store in order of increasing sigmatheta.
   %
   %for (nn = ntp-1; nn >= 0; nn--)   
   for nn = ntp :-1: 1
 
     %fscanf(t_vs_p,'%lf %lf',&p1,&t1);
     tmp = str2num( fgetl(t_vs_p) );

     if length(tmp) ~= 3
        error(['Invalid file format on line ' num2str(nn+6) ' in file ' infile])
     end

     % convert from mbar to mks %
     pdat(nn) = 100.0*tmp(1); 
     tdat(nn) = tmp(2);
   end

   fclose(t_vs_p);




