function remap_vars = remapEpicVar( epic_vars, nc_file, var_name, remap_var_name )
%
% epic_vars = remapEpicVar( epic_vars, nc_file, var_name, remap_var_name )
%
% Function horizontally interpolates the variable var_name onto the index space of remap_var_name.
%
%
TRUE=1;  FALSE=0;
DEG=pi/180.0;

if nargin<4
   error(' Missing input :  epic_vars, nc_file, var_name, remap_var_name')
end



%
% Find Original and Remap Variables
%
ivn = -1;  irvn = -1;
for iv=1:length(epic_vars)
   if strcmp( epic_vars(iv).name, var_name )
      ivn=iv;
   end
   if strcmp( epic_vars(iv).name, remap_var_name )
      irvn=iv;
   end
end

if ivn==-1
   error([' Could not find variable "' var_name '" in epic_vars'])
end

if irvn==-1
   error([' Could not find variable "' remap_var_name '" in epic_vars'])
end
%fprintf([' Remapping ' var_name ' (ivn=' num2str(ivn) ') to the index space of ' remap_var_name ' (irvn=' num2str(irvn) ')\n'])

%
% Get Grid Information for the Variable and the Remap Variable
%
dlt = getNCattribute( nc_file, 'grid_dlt'  );
dln = getNCattribute( nc_file, 'grid_dln'  );
re  = getNCattribute( nc_file, 'planet_re' );
rp  = getNCattribute( nc_file, 'planet_rp' );

lt = getNCvardata( nc_file, epic_vars(ivn).dim(3).name );
ln = getNCvardata( nc_file, epic_vars(ivn).dim(4).name );

rm_lt = getNCvardata( nc_file, epic_vars(irvn).dim(3).name );
rm_ln = getNCvardata( nc_file, epic_vars(irvn).dim(4).name );

var_data    = epic_vars(ivn).data;
rm_var_data = epic_vars(irvn).data;

ILO = epic_vars(ivn).ilo;  IHI = epic_vars(ivn).ihi;   IOFFSET = 1-ILO;  
JLO = epic_vars(ivn).jlo;  JHI = epic_vars(ivn).jhi;   JOFFSET = 1-JLO;
KLO = epic_vars(ivn).klo;  KHI = epic_vars(ivn).khi;


%
% Make Original Variable Periodic, if necessary
%
left_is_periodic=FALSE;
if rm_ln(1) < ln(1)
%fprintf([' adding left periodic data to ' var_name '\n'])
   for I=IHI+1 +IOFFSET : -1 : ILO+1 +IOFFSET
      var_data(:,:,:,I) = var_data(:,:,:,I-1);
      ln(I)         = ln(I-1);
   end
   if rm_ln(1) < ln(1)
     var_data(:,:,:,1) = var_data(:,:,:,IHI+1 +IOFFSET);
   else
     var_data(:,:,:,1) = var_data(:,:,:,2);
   end
   ln(1) = ln(2) - dln;
   ILO = ILO-1;   IOFFSET=1-ILO;
   left_is_periodic=TRUE;
end
if max(rm_ln) > max(ln)
%fprintf([' adding right periodic data to ' var_name '\n'])
   I = IHI+IOFFSET;
   if max(rm_ln) > max(ln)
     var_data(:,:,:,I+1) = var_data(:,:,:,ILO+left_is_periodic + IOFFSET);
   else
     var_data(:,:,:,I+1) = var_data(:,:,:,I);
   end
   ln(I+1) = ln(I) + dln; 
   IHI = IHI+1;
end


%
% Determine if One Sided Interpolation is Necessary 
%    (southern and northern edges of domain).  If so,
%    create dummy data that will translate the centered
%    interpolation operation to one sided interpolation.
%
if max(rm_lt) > max(lt) 
   lt_rm = rm_lt(length(rm_lt));  lt_rmm = rm_lt(length(rm_lt)-1);
   J=JHI+JOFFSET;
   lt_j = lt(J);  lt_jp = max( lt(J)+dlt, lt_rm );  lt_jm = lt(J-1);

   RT = getMapFactor_rlt(0.5*(lt_jp+lt_rm)*DEG, re, rp) * (lt_jp - lt_rm);
   RB = getMapFactor_rlt(0.5*(lt_rm+lt_j )*DEG, re, rp) * (lt_rm - lt_j );
   %Rj = getMapFactor_rlt(            lt_rm*DEG, re, rp) * (lt_jp - lt_j );
   Rj = RT + RB;

   RTm = getMapFactor_rlt(0.5*(lt_j  +lt_rmm)*DEG, re, rp) * (lt_j   - lt_rmm);
   RBm = getMapFactor_rlt(0.5*(lt_rmm+lt_jm )*DEG, re, rp) * (lt_rmm - lt_jm );
   %Rm = getMapFactor_rlt(           lt_rmm*DEG, re, rp) * (lt_j  - lt_jm);
   Rm  = RTm + RBm;

   if RB>0
      var_data(:,:,J+1,:) = (Rj-RT)/RB * var_data(:,:,J,:)  +  (Rj/Rm) * (var_data(:,:,J,:) - var_data(:,:,J-1,:));
   else
      var_data(:,:,J+1,:) = var_data(:,:,J,:);
   end
   lt(J+1) = lt_jp;
   JHI = JHI+1;
end

if rm_lt(1) < lt(1) 
   lt_rm  = rm_lt(1); lt_rmp = rm_lt(2);
   J=JLO+JOFFSET;
   lt_j    = lt(J); lt_jp   = lt(J+1);  lt_jp2  = lt(J+2);
   lt_jm   = min( lt(J)-dlt, lt_rm );

   RT = getMapFactor_rlt(0.5*(lt_j  +  lt_rm)*DEG, re, rp) * (lt_j   - lt_rm);
   RB = getMapFactor_rlt(0.5*(lt_rm +  lt_jm)*DEG, re, rp) * (lt_rm  - lt_jm);
   %Rj = getMapFactor_rlt(              lt_rm *DEG, re, rp) * (lt_j   - lt_jm);
   Rj = RT + RB;

   RTp = getMapFactor_rlt(0.5*(lt_jp  + lt_rmp)*DEG, re, rp) * ( lt_jp  - lt_rmp );
   RBp = getMapFactor_rlt(0.5*(lt_rmp + lt_j  )*DEG, re, rp) * ( lt_rmp - lt_j   );
   %Rp = getMapFactor_rlt(              lt_rmp*DEG, re, rp) * (lt_jp2 - lt_jp);
   Rp  = RTp + RBp;

   for J=JHI+1+JOFFSET : -1 : JLO+1 + JOFFSET
      var_data(:,:,J,:) = var_data(:,:,J-1,:);
      lt(J)         = lt(J-1);
   end
   JLO = JLO-1;  JOFFSET=1-JLO;
   J   = JLO+1 + JOFFSET;

   if RT>0
      var_data(:,:,J-1,:) = (Rj-RB)/RT * var_data(:,:,J,:)  -  (Rj/Rp) * (var_data(:,:,J+1,:) - var_data(:,:,J,:));
   else
      var_data(:,:,J-1,:) = var_data(:,:,J,:);
   end
   lt(1) = lt_jm;
end


%
% Find the remapping indicies 
%
for ii=1:length(rm_ln)
  clear ie igt ilt
  ie = find( rm_ln(ii)==ln );
  if length(ie)>0
     iL(ii) = ie;  iR(ii) = ie;
  else
     igt = find( rm_ln(ii)>ln );
     ilt = find( rm_ln(ii)<ln );
     iL(ii) = igt(length(igt));
     iR(ii) = ilt(1);
  end
end
clear ie igt ilt

for jj=1:length(rm_lt)
  clear je jgt jlt
  je = find( rm_lt(jj)==lt );
  if length(je)>0
     jB(jj) = je;  jT(jj) = je;
  else
     jgt = find( rm_lt(jj)>lt );
     jlt = find( rm_lt(jj)<lt );
     jB(jj) = jgt(length(jgt));
     jT(jj) = jlt(1);
  end
end
clear je jgt jlt



%
% Remap the variable using area weighted averaging
%
N=size(rm_var_data);
for jj=1:N(3)
   lt_jp = lt( jT(jj) );
   lt_jm = lt( jB(jj) );
   lt_rm = rm_lt(jj);

   RT =     getMapFactor_rlt(0.5*(lt_jp+lt_rm)*DEG, re, rp) * (lt_jp - lt_rm);
   RB =     getMapFactor_rlt(0.5*(lt_jm+lt_rm)*DEG, re, rp) * (lt_rm - lt_jm);
   %Rj = 2.0*getMapFactor_rlt(            lt_rm*DEG, re, rp) * (lt_jp - lt_jm);
   Rj = 2.0*(RT+RB);

   if Rj > 0 
      for ii=1:N(4)
         rm_var_data(:,:,jj,ii) = ( RT*(var_data(:,:,jT(jj),iR(ii))  +  var_data(:,:,jT(jj),iL(ii))) ...
                                  + RB*(var_data(:,:,jB(jj),iR(ii))  +  var_data(:,:,jB(jj),iL(ii))) ...
                                  ) / Rj;
      end
   else  % jT(jj) == jB(jj)
      for ii=1:N(4)
         rm_var_data(:,:,jj,ii) = 0.5*( var_data(:,:,jT(jj),iR(ii))  +  var_data(:,:,jT(jj),iL(ii)) );
      end
   end
end


%
% Check for poles.  Set velocities to zero.  Set scalar variables to the mean 
%   remapped values at the poles.
%
if rm_lt(1)==-90.0
   if strcmp(var_name, 'u')  |  strcmp(var_name, 'v')
      rm_var_data(:,:,1,:) = 0.0;
   else
      for it=1:N(1)
         for ik=1:N(2)
            rm_var_data(it,ik,1,:) = mean( rm_var_data(it,ik,1,:) );
         end
      end
   end
end

if rm_lt(N(3))==90.0
   if strcmp(var_name, 'u')  |  strcmp(var_name, 'v')
      rm_var_data(:,:,N(3),:) = 0.0;
   else
      for it=1:N(1)
         for ik=1:N(2)
            rm_var_data(it,ik,N(3),:) = mean( rm_var_data(it,ik,N(3),:) );
         end
      end
   end
end


%
% Change data and coordinates of remapped variable 
%
remap_vars                  = epic_vars;
remap_vars(ivn)             = epic_vars(irvn);
remap_vars(ivn).name        = epic_vars(ivn).name;
remap_vars(ivn).dim(1).name = epic_vars(ivn).dim(1).name;
remap_vars(ivn).dim(2).name = epic_vars(ivn).dim(2).name;
remap_vars(ivn).data        = [];
remap_vars(ivn).data        = rm_var_data;

