

function [enthalpy, fgibb, fpe, uoup] = return_enthalpy( planet, fp, pressure, temperature, thermo, grid_obj )
%
% Adapted from Peter Gierasch's Fortran subroutine get_enthalpy().
%
% NOTE:  The calling program must initialize this function with a call
%        to thermo_setup().
%
% (code translated from epic_funcs_diag.c)
%

MDIM_THERMO  = 128;   % (taken from epic_datatypes.h)


  if (planet.x_h2 == 0.0)  
    %
    % No hydrogen, so assume cp is constant and set enthalpy = cp*T.
    %
    enthalpy = planet.cpr*temperature;
    fgibb   = 0.0;
    fpe     = 0.0;
    uoup    = 0.0;
  else  
    if (temperature <= 20.0)  
      enthalpy = planet.cpr*temperature;
      fgibb   = 0.0;
      fpe     = 1.;
      uoup    = 175.1340;
    elseif (temperature > 500.0)  
      ho       = 1545.3790+3.5*(temperature-500.0);
      hp       = 1720.3776+3.5*(temperature-500.0);
      %
      % NOTE: Should replace "planet.x_3" with a loop
      %       over condensable species.
      %
      enthalpy = (planet.x_h2)*((1.0-fp)*ho+fp*hp)                         ...
                +(planet.x_he*2.5+planet.x_3*3.5)*temperature;
      fgibb   = planet.x_h2*2.5*(CCPLN_THERMO-CCOLN_THERMO)*temperature    ...
                    -planet.x_h2*(hp-ho);
      fpe     = 0.25;
      uoup    = 0.0;
    else  
      % 0 < em < MDIM_THERMO-1
      em = (MDIM_THERMO-1)*                                                ...
                 (temperature                   -thermo.t_grid(0+1)) /     ...
                 (thermo.t_grid(MDIM_THERMO-1+1)-thermo.t_grid(0+1));
      m = round(em);
      % 0 < m < MDIM_THERMO-2
      if (m == MDIM_THERMO-1)  
        m = m-1;
        fract = 1.0;
      else  
        fract = mod(em,1.0);
      end
      M=m+1;
      %for (j = 0; j < 5; j++)  
      for j = 0 : 4
        J=j+1;
        thermo_vector(J) = (1.0-fract)*thermo.array(J,M  )                 ...
                          +(    fract)*thermo.array(J,M+1);
      end
      enthalpy = (planet.x_h2)*((1.0-fp)*thermo_vector(1)                  ...
                               +(    fp)*thermo_vector(2))                 ...
                +(planet.x_he*2.5+planet.x_3*3.5)*temperature;
      fgibb   = planet.x_h2*thermo_vector(3);
      fpe     = thermo_vector(4);
      uoup    = thermo_vector(5);
    end
  end

  if strcmp(grid_obj.eos,'virial')
    % 
    % Make non-ideal equation of state corrections. Use enthalpy-correction 
    % equation on p.x of Dymond and Smith (1980); see also p.xiv.
    %
    % The quantities fgibb and uoup are differences between ortho and para
    % hydrogen.  Since we are not distinguishing these in the non-ideal 
    % equation of state, we make no corrections to fgibb and uoup.
    %
    error(' Option "virial" is not yet supported')

    %b         = sum_xx(planet,b_vir, temperature);
    %b1        = sum_xx(planet,b1_vir,temperature);
    %enthalpy += pressure*temperature*(b-b1);
  end

  rgas     = planet.rgas;
  enthalpy = rgas * enthalpy;
  fgibb    = rgas * fgibb;
  uoup     = rgas * uoup;


