function sigmatheta = return_sigmatheta(theta, p, pbot, ptop)
%
% Hybrid coordinate, sigmatheta, as a function of pressure and potential temperature.
% Use double precision to increase accuracy of diagnostic theta calculations.
%
% (code translated from epic_funcs_diag.c)
%

  if (p <= ptop) 
    %disp('returning theta')
    sigmatheta = theta;
  elseif (p <= pbot) 
    %disp('f(sigma) + g(sigma)theta')
    sigma      = get_sigma(pbot,p,ptop);
    sigmatheta = f_sigma(sigma) + g_sigma(sigma)*theta;
  else 
    error(['pbot=' num2str(pbot) ', ptop=' num2str(ptop) '; p=' num2str(p) ' out of range'])
  end


