
function  [theta, theta_ortho, theta_para] = return_theta(planet, fp, p, temperature, grid_obj)
%
% Adapted from Peter Gierasch's Fortran subroutine get_theta().
%
% NOTE:  The calling program must initialize this function with a call
%        to thermo_setup().
%
% (code translated from epic_funcs_diag.c)
%

if nargin<5
   error('Missing input: planet, fp, p, temperature, grid_obj')
end

MDIM_THERMO  =  128;       % (defined in epic_datatypes.h)
CCOLN_THERMO = -2.105769;  
CCPLN_THERMO = -1.666421;


  if (planet.x_h2 == 0.0)  
    %
    % No hydrogen, so use standard definition of theta.
    %
    theta = temperature * (grid_obj.press0/p)^planet.kappa;
  else  
    %
    % Use mean theta as defined in Dowling et al (1998), to handle ortho/para hydrogen.
    %
    if (temperature <= 20.0)  
      theta        = temperature;
      theta_ortho  = temperature;
      theta_para   = temperature;
    elseif (temperature > 500.0)  
      cc           = planet.x_h2*2.5*((1.0-fp)*CCOLN_THERMO+fp*CCPLN_THERMO);
      theta        = exp(cc/planet.cpr)*                                ...
                      temperature^(( 3.5*planet.x_h2                    ... % 3.5 since high T 
                                        +2.5*planet.x_he                ...
                                        +3.5*planet.x_3 )/planet.cpr);
      tt           = temperature^(3.5/2.5);
      theta_ortho = 0.12175*tt;
      theta_para  = 0.18892*tt;
    else  
      % 0 < em < MDIM_THERMO-1
      em = (MDIM_THERMO-1)*                                                 ...
                         (temperature               -thermo.t_grid(1))/     ...
                         (thermo.t_grid(MDIM_THERMO)-thermo.t_grid(1));
      m  = round(em);
      %  0 < m < MDIM_THERMO-2
      if (m == MDIM_THERMO-1)  
        m      = m-1;
        fract  = 1.0;
      else  
        fract = mod(em,1.0);
      end
      %for (j = 0; j < 2; j++)  
      for j=1:2
        thermo_vector(j) = (1.0-fract)*thermo.theta_array(j,m+1)   ...
                           +(   fract)*thermo.theta_array(j,m+2);
      end

      thetaln = (planet.x_h2)*( (1.0-fp)*log(thermo_vector(1))                  ...
                                +(   fp)*log(thermo_vector(2)) )                ...
               +(planet.x_he*2.5+planet.x_3*3.5)*log(temperature)/planet.cpr;

      theta       = exp(thetaln);
      theta_ortho = thermo_vector(1);
      theta_para  = thermo_vector(2);
    end
    pp           = (grid_obj.press0/p)^(planet.kappa);
    theta        = pp * theta;
    theta_ortho  = pp * theta_ortho;
    theta_para   = pp * theta_para;
  end

  if strcmp(grid_obj.eos,'virial')
    % 
    % Make non-ideal equation of state corrections.
    %
    % NOTE: Need to check validity of these formulas.
    %       The formula in Dymon and Smith (1980) on p.x is confusing,
    %       and the implementation below may be in error.
    %
    error('Option "virial" is currently not supported')

    %kappa         = planet.kappa;
    %b             = sum_xx(planet,b_vir, temperature);
    %b1            = sum_xx(planet,b1_vir,temperature);
    %tmp           = exp(-p*(b+b1)*kappa);
    %theta        *= tmp;

    %kappa         = planet.kappa*R_GAS/(2.016*planet.rgas);
    %b             = b_vir( "H_2","H_2",temperature);
    %b1            = b1_vir("H_2","H_2",temperature);
    %tmp           = exp(-p*(b+b1)*kappa);
    %*theta_ortho *= tmp;
    %*theta_para  *= tmp;
  end

  %return theta;
end
