
function reverseFigAndAxesColors( fig_num )

if nargin<1
   fig_num = gcf;
end


white = [1 1 1];

fig_ch = get(fig_num,'Children');
fig_color = get(fig_num,'Color');

%
% Axes backgrounds
%
for fc=1:length(fig_ch)
   if not( strcmp( get(fig_ch(fc),'Type'), 'uimenu' ))

      % Axes background
      c = get( fig_ch(fc), 'Color' );
      if ischar(c),  if strcmp(c,'none')
          c = fig_color;
      end, end
      pres_color = white - c;
      %pres_color = white - get( fig_ch(fc), 'Color' );
      set( fig_ch(fc), 'Color', pres_color );

   
      % X,Y,Z axes
      c = get( fig_ch(fc), 'XColor' );
      if ischar(c),  if strcmp(c,'none')
          c = fig_color;
      end, end
      pres_color = white - c;
      %pres_color = white - get( fig_ch(fc), 'XColor' );
      set( fig_ch(fc), 'XColor', pres_color );

      c = get( fig_ch(fc), 'YColor' );
      if ischar(c),  if strcmp(c,'none')
          c = fig_color;
      end, end
      pres_color = white - c;
      %pres_color = white - get( fig_ch(fc), 'YColor' );
      set( fig_ch(fc), 'YColor', pres_color );

      c = get( fig_ch(fc), 'ZColor' );
      if ischar(c),  if strcmp(c,'none')
          c = fig_color;
      end, end
      pres_color = white - c;
      %pres_color = white - get( fig_ch(fc), 'ZColor' );
      set( fig_ch(fc), 'ZColor', pres_color );

   
      % Title 
      tmp_id = get( fig_ch(fc),'Title' );
      c = get( tmp_id, 'Color' );
      if ischar(c),  if strcmp(c,'none')
          c = fig_color;
      end, end
      pres_color = white - c;
      %pres_color = white - get( tmp_id, 'Color' );
      set( tmp_id, 'Color', pres_color );
   
   
      ax_ch = get( fig_ch(fc), 'Children' );
      for ac=1:length(ax_ch)
        % Vector Plots
        %if strcmp( get(ax_ch(ac),'Type'), 'hggroup' )
        if strcmp( get(ax_ch(ac),'Tag'), 'vector-plot' )
   
           c = get( ax_ch(ac), 'Color' );
           if ischar(c),  if strcmp(c,'none')
               c = fig_color;
           end, end
           pres_color = white - c;
           %pres_color = white - get( ax_ch(ac), 'Color' );
           set( ax_ch(ac), 'Color', pres_color );
   
        end
   
        % Text Boxes
        if strcmp( get(ax_ch(ac),'Type'), 'text' )
   
           c = get( ax_ch(ac), 'BackgroundColor' );
           if ischar(c),  if strcmp(c,'none')
               c = fig_color;
           end, end
           pres_color = white - c;
           %pres_color = white - get( ax_ch(ac), 'BackgroundColor' );
           set( ax_ch(ac), 'BackgroundColor', pres_color );
   
           c = get( ax_ch(ac), 'Color' );
           if ischar(c),  if strcmp(c,'none')
               c = fig_color;
           end, end
           pres_color = white - c;
           %pres_color = white - get( ax_ch(ac), 'Color' );
           set( ax_ch(ac), 'Color', pres_color );
   
        end
      end

   end
end


%
% Figure background 
%   - Colorbars require figure background to be changed AFTER axes backgrounds
%
pres_color = white - get(fig_num, 'Color');
set(fig_num, 'Color', pres_color);

