


%
% Prepare extract_it 
%
if strcmp(extract_it,'first')
  clear extract_it
  nc_file = nc_file(1);
  extract_it = 1;
elseif strcmp(extract_it,'last')
  clear extract_it
  nc_file = nc_file(length(nc_file));
  extract_it = length( var(nc_file.pntr,'time')  );
elseif strcmp(extract_it,'all')  |   extract_it==-1
  clear extract_it
  extract_it = 1:length( var(nc_file(1).pntr,'time')  );
  %for inc=2:1:num_files
  %   num_new_it = length( var(nc_file(inc).pntr,'time') );
  %   first_it = extract_it(length(extract_it)) + 1;
  %   extract_it(length(extract_it)+1 : length(extract_it)+num_new_it) = first_it : first_it+num_new_it-1;
  %end
elseif isnumeric(extract_it)
  extract_it = sort(extract_it);
else
  error('  Invalid input:  extract_it')
end



%
% Subtract Zonal Mean
%
if length(who('subtract_zonal_mean'))  &  iv==1
  if subtract_zonal_mean
    return_zonal_edies = 4;
    epic_vars = getZonalReducedEpicData( epic_vars, return_zonal_edies );
  end
end


%
% Extend Surface Data (useful for viewing zonal reduction plots at surface)
%
if length(who('extend_surface_data'))  &  iv==1
  for iv2=1:length(epic_vars)
    if not(strcmp(epic_vars(iv2).name,'p2'))  &  not(strcmp(epic_vars(iv2).name,'p3'))
      % check that p2 or p3 exist
      var_is_on_interface=FALSE;
      if strfind(epic_vars(iv2).name, '3') > 0
        var_is_on_interface=TRUE;
      end
      if strcmp(epic_vars(iv2).name, 'theta') > 0
        var_is_on_interface=TRUE;
      end
      if var_is_on_interface
        p3_exists_in_epic_vars=FALSE;
        for iv3=1:length(epic_vars)
          if strcmp( epic_vars(iv3).name, 'p3' )
            p3_exists_in_epic_vars=TRUE;
          end
        end
        if not(p3_exists_in_epic_vars)
          error(' misssing variable "p3" for use with "extend_surface_data"')
        end
      else
        p2_exists_in_epic_vars=FALSE;
        for iv3=1:length(epic_vars)
          if strcmp( epic_vars(iv3).name, 'p2' )
            p2_exists_in_epic_vars=TRUE;
          end
        end
        if not(p2_exists_in_epic_vars)
          error(' misssing variable "p2" for use with "extend_surface_data"')
        end
      end
      clear p3_exists_in_epic_vars p2_exists_in_epic_vars
    
      % extend surface data
      N=size(epic_vars(iv2).data);
      epic_vars(iv2).data(:,N(2)+1,:,:) = epic_vars(iv2).data(:,N(2),:,:);
    else

      % add an additional pressure level
      convert_p_units=1.0;
      if strcmp(epic_vars(iv2).units,'Pa') & strcmp(extend_surface_data.units,'mb')
        convert_p_units = 100.0;
      elseif strcmp(epic_vars(iv2).units,'mb') & strcmp(extend_surface_data.units,'Pa')
        convert_p_units = 0.01;
      end
      N=size(epic_vars(iv2).data);
      epic_vars(iv2).data(:,N(2)+1,:,:) = extend_surface_data.pressure * convert_p_units;
    end
  end
end


%
% Remap to pressure surfaces
%
if remap_to_pressure_surfaces  &  iv==1   %&  it==1  &  ik==1
  fprintf(' remapping data to pressure surfaces .....');
  processEpicVarsForPressureCoord;

  %extract_ik = extract_ik_non_remap;
  if not(strcmp(extract_ik_non_remap,'all'))
    for iv2=1:num_plot_vars+vector_plot
      remap_epic_vars(iv2) = epic_vars(iv2);
      clear tmp_data
      for it=1:length(extract_it)
        ikcopy=1;
        for ik=1:length(extract_ik_non_remap)
          tmp_data(it,ikcopy,:,:) = epic_vars(iv2).data(it, extract_ik_non_remap(ik), :,:);
          ikcopy=ikcopy+1;
        end
      end
      remap_epic_vars(iv2).data = [];
      remap_epic_vars(iv2).data = tmp_data;
    end
    clear epic_vars
    epic_vars = remap_epic_vars;
    clear remap_epic_vars

    for ik=1:length(extract_ik_non_remap)
      tmp_press_plot_y(ik) = press_plot_y( extract_ik_non_remap(ik) );
    end
    clear press_plot_y
    press_plot_y = tmp_press_plot_y;
    clear tmp_press_plot_y;
  
    extract_ik = extract_ik_non_remap;
  else
    %error('extract_ik="all" is invalid when remapping to pressure surfaces');
    extract_ik = epic_vars(1).klo : epic_vars(1).khi;
  end

  if vector_plot
    num_plot_vars = 1;
  else
    num_plot_vars = length(vars_to_plot) - p2_needed - p3_needed;
  end
  fprintf('done\n');
  fprintf(' (see press_plot_y for interpolated pressres)\n');
end




%
% Prepare extract_ik 
%
if strcmp(extract_ik,'top')
  clear extract_ik
  extract_ik = 1;
elseif strcmp(extract_ik,'bottom')
  clear extract_ik
  extract_ik = length( var(nc_file(1).pntr,'sigmatheta_u')  );
elseif strcmp(extract_ik,'all')
  clear extract_ik
  extract_ik = 1:length( var(nc_file(1).pntr,'sigmatheta_u')  );
else
  extract_ik = sort(extract_ik);
end


if strcmp(opaque_ik,'top')
  clear opaque_ik
  opaque_ik = 1;
elseif strcmp(opaque_ik,'bottom')
  clear opaque_ik
  opaque_ik = length( var(nc_file(1).pntr,'sigmatheta_u')  );
elseif strcmp(opaque_ik,'all')
  clear opaque_ik
  opaque_ik = 1:length( var(nc_file(1).pntr,'sigmatheta_u')  );
end


%
% Determine if the variable is in the layer or on the interface
%
% NOTE: Matlab did not evaluate the "or" statement correctly!!!
%if strfind(vars_to_plot(iv).name, 'theta')  |  strfind(vars_to_plot(iv).name, '3')  
var_is_on_interface=FALSE;
if strfind(epic_vars(iv).name, '3') > 0
  var_is_on_interface=TRUE;
end
if strcmp(epic_vars(iv).name, 'theta') > 0
  var_is_on_interface=TRUE;
end


%
% Calculate Vertical Average
%
if vertical_ave_plot_on  &  iv==1
  fprintf(' calculating vertical average .....');

  for iv2=1:length(vars_to_plot)
    grid_obj = getNCgridObject( nc_file(1).pntr );
    sigmatheta_all = grid_obj.sigmatheta;
    if var_is_on_interface
      for ik2=1:length(extract_ik)
        k = extract_ik(ik2);
        dsigmatheta(ik2) = sigmatheta_all( 2*k-1 )  -  sigmatheta_all( 2*k+1 );
      end
    else
      for ik2=1:length(extract_ik)
        k = extract_ik(ik2);
        dsigmatheta(ik2) = sigmatheta_all( 2*k )  -  sigmatheta_all( 2*k+2 );
      end
    end
    sum_dsigmatheta = sum( dsigmatheta );

    clear tmp_data
    tmp_data = epic_vars(iv2).data;
    N = size(tmp_data);

    for it2=1:N(1)
      clear ave_data
      ave_data(1:N(3),1:N(4)) = 0.0;
      for ik2=1:N(2)
        for jj=1:N(3)
          for ii=1:N(4)
            ave_data(jj,ii) = ave_data(jj,ii) + tmp_data(it2,ik2,jj,ii).*dsigmatheta(ik2);
          end
        end
      end
      ave_data(:,:) = ave_data(:,:) ./ sum_dsigmatheta ;
      tmp_data(it2,1,:,:) = ave_data(:,:);
    end

    epic_vars(iv2).data = [];
    epic_vars(iv2).data(:,:,:,:) = tmp_data(it2,1,:,:);   
    epic_vars(iv2).klo = 1;
    epic_vars(iv2).khi = 1;
  end
  
  extract_ik = 1;

  fprintf('done\n');
end


%
% Prepare Zonal Reduction Parameters
%
if zonal_anomoly_plot_on | zonal_max_plot_on  |  zonal_average_plot_on  |  longitude_slice_plot 
  % find the transition layer
  grid_obj = getNCgridObject( nc_file(1).pntr );
  if var_is_on_interface
    %fprintf([vars_to_plot(iv).name ' is an interface variable\n'])
    for itmp=1:length(extract_ik)
      if (extract_ik(itmp) == grid_obj.k_sigma-1)
        k_sigma_line = length(extract_ik) - itmp + 1;
      end
    end
  else
    %fprintf([vars_to_plot(iv).name ' is a layer variable\n'])
    for itmp=1:length(extract_ik)
      if (extract_ik(itmp) == grid_obj.k_sigma)
        k_sigma_line = length(extract_ik) - itmp + 1;
      end
    end
  end
  clear grid_obj itmp

  extract_ik=1;
end



