
function set_p2etc( planet, theta_switch, grid_obj)

%
% The diagnostic variables HDRY3, PDRY3, P2, P3, and THETA2 are updated
% here rather than in store_diag(), because they are directly 
% related to the prognostic variables HDRY and THETA and need to be updated
% more often than the other diagnostic variables.
%/

global ILO IHI JLO JHI KLO KHI KHI1 P3 PTOP H2

  if (grid_obj.nq > 0)  
     error('Option grid_obj.nq>0 is not yet supported')
%    %
%    % Calculate H2 (total hybrid density) from HDRY and HQ_i (mass mixing ratios).
%    %
%    for (K = KLO; K <= KHI; K++)  
%      kk = 2*K;
%      for (J = JLOPAD; J <= JHIPAD; J++)  
%        for (I = ILOPAD; I <= IHIPAD; I++)  
%          H2(K,J,I) = HDRY(K,J,I);
%          for (iq = 0; iq < grid_obj.nq; iq++)  
%            %
%            % NOTE: HQ is carried on layer interfaces, so use get_var().
%            %/
%            H2(K,J,I) += get_var(planet,grid_obj.is[iq],grid_obj.ip[iq],grid_obj.it_h,kk,J,I);
%          end
%        end
%      end
%    end
  else
     H2(KLO+1:KHI+1, JLO+1:JHI+1, ILO+1:IHI+1) = 0.0;
  end
  
  %
  % NOTE: In the dry case, grid_obj.nq = 0 and the memory for H2 is the same as HDRY; 
  %       same for P3 and PDRY3.
  %
  %for (J = JLOPAD; J <= JHIPAD; J++)  
    %for (I = ILOPAD; I <= IHIPAD; I++)  
  for jj = JLO : JHI
    J = jj+1;
    for ii = ILO : IHI
      I = ii+1;
      %
      % P3 is a straightforward integral of H2.
      %
      k = 0;
      K=k+1;
      P3(K,J,I) = PTOP(J,I);
      %for (K = KLO; K <= KHI; K++)  
      for k=KLO : KHI
        kk = 2*k;
        K  = k+1;
        KK = kk+1;
        P3(K,J,I) = P3(K-1,J,I)+grid_obj.dsgth(KK)*planet.g*H2(K,J,I);
      end

%% START HERE

      %
      % Apply the diagnostic value of pressure to P3 in the pure-sigma portion of the model.
      %/
      ptop = P3(0  ,J,I);
      pbot = P3(KHI,J,I);
      for (K = grid_obj.k_sigma-1; K < KHI; K++)  
        sigma     = (grid_obj.sigmatheta[2*K+1]-grid_obj.zeta0)/(grid_obj.zeta1-grid_obj.zeta0);
        P3(K,J,I) = get_p_sigma(pbot,sigma,ptop);
      end
      %
      % Avoid dropping below minimum h.
      %/
      for (K = grid_obj.k_sigma-2; K >= KLO; K--)  
        P3(K,J,I) = MIN(P3(K,J,I),P3(K+1,J,I)-planet.g*grid_obj.h_min[K+1]*grid_obj.dsgth[2*(K+1)]);
      end

      %
      % Update H2.
      %/
      for (K = KLO; K <= KHI; K++)  
        kk = 2*K;
        H2(K,J,I) = get_h(planet,kk,J,I,TOTAL);
      end
      if (grid_obj.nq > 0)  
        %
        % HDRY and H2 are separate memory, so update HDRY.
        %/
        for (K = KLO; K <= KHI; K++)  
          kk = 2*K;
          HDRY(K,J,I) = get_h(planet,kk,J,I,DRY);
        end
      end
    end
  end

  if (grid_obj.nq > 0)  
    for (J = JLOPAD; J <= JHIPAD; J++)  
      for (I = ILOPAD; I <= IHIPAD; I++)  
        %
        % PDRY3 is a straightforward integral of HDRY.
        %/
        K = 0;
        PDRY3(K,J,I) = PTOP(J,I);
        for (K = KLO; K <= KHI; K++)  
          kk        = 2*K;
          PDRY3(K,J,I) = PDRY3(K-1,J,I)+grid_obj.dsgth[kk]*planet.g*HDRY(K,J,I);
        end
      end
    end
  end

  if (theta_switch == UPDATE_THETA)  
    %
    % Apply the diagnostic value of potential temperature to THETA outside the pure-sigma region.
    %/
    for (J = JLOPAD; J <= JHIPAD; J++)  
      for (I = ILOPAD; I <= IHIPAD; I++)  
        ptop = P3(0,  J,I);
        pbot = P3(KHI,J,I);
        for (K = 0; K < grid_obj.k_sigma-1; K++)  
          sigma        = get_sigma(pbot,P3(K,J,I),ptop);
          THETA(K,J,I) = (grid_obj.sigmatheta[2*K+1]-f_sigma(sigma))/g_sigma(sigma);
        end
      end
    end
  end

  %
  % Calculate P2, H3, HDRY3.
  %/
  for (J = JLOPAD; J <=JHIPAD; J++)  
    for (I = ILOPAD; I <= IHIPAD; I++)  
      for (K = KLO; K <= KHI; K++)  
        kk = 2*K;
        %
        % P2 depends on P3.
        %/
        P2(K,J,I) = get_p(planet,P2_INDEX,kk,J,I);
      end

      %
      % Top and bottom of model.
      %/
      K = 0;
      P2(K,J,I) = P3(K,J,I)*P3(K,J,I)/P2(K+1,J,I);

      if (strcmp(planet.type,'gas-giant') == 0)  
        % 
        % Set gas-giant abyssal layer.
        %/
        K = grid_obj.nk+1;
        P2(K,J,I) = P3(K-1,J,I)*P3(K-1,J,I)/P2(K-1,J,I);
      end

      for (K = KLO; K <= KHI; K++)  
        kk        = 2*K+1;
        H3(K,J,I) = get_h(planet,kk,J,I,TOTAL);
      end
      H3(KLO-1,J,I) = H3(KLO,J,I);
 
      if (grid_obj.nq > 0)  
        for (K = KLO; K <= KHI; K++)  
          kk           = 2*K+1;
          HDRY3(K,J,I) = get_h(planet,kk,J,I,DRY);
        end
        HDRY3(KLO-1,J,I) = HDRY3(KLO,J,I);
      end
    end
  end

  if (theta_switch == UPDATE_THETA)  
    %
    % Set THETA2.
    %/
    for (J = JLOPAD; J <=JHIPAD; J++)  
      for (I = ILOPAD; I <= IHIPAD; I++)  
        ptop = P3(0,  J,I);
        pbot = P3(KHI,J,I);
        for (K = KLO; K <= grid_obj.k_sigma-2; K++)  
          %
          % THETA2 is known diagnostically.
          %
          % NOTE: THETA2 is known diagnostically down to K = grid_obj.k_sigma-1,
          %       however this last value involves dividing by a g_sigma()
          %       value that is nearly zero, so we back away from it and
          %       use the average value instead. 
          %/
          sigma         = get_sigma(pbot,P2(K,J,I),ptop);
          THETA2(K,J,I) = (grid_obj.sigmatheta[2*K]-f_sigma(sigma))/g_sigma(sigma);
        end
        for (K = grid_obj.k_sigma-1; K <= KHI; K++)  
          %
          % THETA2 is set to an average of THETA.
          %/
          THETA2(K,J,I) = onto_kk(planet,THETA_INDEX,THETA(K-1,J,I),THETA(K,J,I),2*K,J,I);
        end

        if (strcmp(planet.type,'gas-giant') == 0)  
          % 
          % Set gas-giant abyssal layer.
          %/
          K             = grid_obj.nk+1;
          THETA2(K,J,I) = THETA(K-1,J,I);
        end
      end
    end
    % No need to apply bc_lateral() here.%/
  end

  return;
end
