function set_pm_on_contour( chan, line_style )
%
% function  set_pm_on_contour( chan, line_style )
%
% Makes negative values on contour plots appear as dashed lines.  
% Arguement line_style is optional and defaults to ':';
%

if nargin<2
  line_style = ':';
end


cont_ids    = get(chan, 'Children' );

for icd=1:length(cont_ids)
  if isfield( get(cont_ids(icd)), 'FaceVertexCData' )
    cont_val = get(cont_ids(icd), 'FaceVertexCData' );
    if min(cont_val) < 0
      set(cont_ids(icd), 'LineStyle', line_style);
    end
  end
end


