function trunc_num_str=trunc2str(num,p)
%
% function trunc2str(num,p)
%
% function rounds the number "num" to its "p"th decimal place,
%   and returns the truncated number as a string.  The case
%   where the truncated number ends in zeros is treated as a
%   special case so that the returned string will always have
%   "p" decimals.
%

if nargin<2, p=0; end

trunc_num = trunc(num, p)  ;
trunc_num_str = num2str( trunc_num );

if p>0

   if abs(trunc_num) < eps
     places = 1;
   elseif floor(log10(trunc_num))<=0
     places = 1;
   else 
     places = floor(log10(trunc_num))+1;
   end

   if length( trunc_num_str ) < places +1 
      trunc_num_str = [trunc_num_str '.'];
   end
   if length( trunc_num_str ) < places +1 +p
      for iz=1:places+p - length(trunc_num_str) + 1
         trunc_num_str = [ trunc_num_str '0'];
      end
   end
end


return
