function writeArraysToTextFile( filepath, array1, array2, array3, array4, array5, array6, array7, array8, array9, array10 )
%
% function writeArraysToTextFile( filepath, array1, array2, array3, array4, array5, array6, array7, array8, array9, array10 )
%
%  Writes up to 10 one dimensional arrays to "filepath" in the format :
%
%        .          .           .           .
%        .          .           .           .
%        .          .           .           .
%        .          .           .           .
%      array1     array2      array3      array4
%        .          .           .           .
%        .          .           .           .
%        .          .           .           .
%        .          .           .           .
%
%
%  NOTES:  Any number of arrays up to 10 can be specified in input.
%          Arrays can be different lengths.
%


if nargin<2
  error(' Missing input "filepath" and "array1", "array2", etc.')
end
if nargin>11
  error(' Too many arrays specified in input (maximum allowable is 10).')
end


%
% Recast input into a single structure of arrays.
%
num_arrays = nargin - 1;
max_lines = 0;
for ia=1:num_arrays
  arrays(ia).data = eval(['array' num2str(ia) ';']);
  arrays(ia).length = length(arrays(ia).data);
  max_lines = max(max_lines, arrays(ia).length );
end


%
% Write data to file.
%
file_id = fopen(filepath, 'w');
for iline=1:max_lines
  clear file_format col*

  file_format = ' ';
  for ia=1:num_arrays
    if iline<=arrays(ia).length
      eval([' col' num2str(ia) ' =  arrays(' num2str(ia) ').data(' num2str(iline) ');' ])
      file_format = [ file_format ' %15.8e  ' ];
    else
      eval([' col' num2str(ia) ' = ''               '';'])
      file_format = [ file_format ' %s  ' ];
    end
  end
  file_format = [file_format '\n'];

  clear write_file_command
  write_file_command   = ['fprintf(' num2str(file_id) ', ''' file_format ''' '];
  for ia=1:num_arrays
    write_file_command = [write_file_command ', col' num2str(ia)]; 
  end
  write_file_command   = [write_file_command ');']; 
  
  eval(write_file_command);
  
end

fclose(file_id);


