
  ProcessData = false;
  PlotData    = true;

  %channel = [ 45 90];
  channel = [ -90 -45 ];

  checkEPICncPATHs
  nc=1;
  curve(nc).name                 = 'Topo';
  curve(nc).planet               = 'Venus';
  curve(nc).experiment           = 'experiment09';
  curve(nc).process_type         = 'ABS_MAX_CHANNEL_SCALAR';
  curve(nc).channel              = channel;
  curve(nc).variables(1).name    = 'u';
  curve(nc).extract_it           = 'all';   %1:46:598;  
  curve(nc).extract_ik           = 'all';
  curve_options(nc).y_data_scale = -1.0;
  curve_options(nc).line_type    = '-b';
  curve_options(nc).line_size    = .75;
  curve_options(nc).marker_size  = 8;
  curve_options(nc).time_units   = 'years';
  curve_options(nc).time_adjust  = 2.99801;  %( in units of "time_units" )
  nc=nc+1;

  curve(nc).name                 = 'Flat';
  curve(nc).planet               = 'Venus_Flat';
  curve(nc).experiment           = 'experiment07';
  curve(nc).process_type         = 'ABS_MAX_CHANNEL_SCALAR';
  curve(nc).channel              = channel;
  curve(nc).variables(1).name    = 'u';
  curve(nc).extract_it           = 'all';   %1:46:598;  
  curve(nc).extract_ik           = 'all';
  curve_options(nc).y_data_scale = -1.0;
  curve_options(nc).line_type    = '-k';
  curve_options(nc).line_size    = .75;
  curve_options(nc).marker_size  = 10;
  nc=nc+1;


  save_processed_data_filename = 'MaxChannelZonalVelVsTime_';
  if channel(1)<0, save_processed_data_filename = [ save_processed_data_filename 'S' num2str(-channel(1)) '_' ];
  else           , save_processed_data_filename = [ save_processed_data_filename 'N' num2str( channel(1)) '_' ];
  end
  if channel(2)<0, save_processed_data_filename = [ save_processed_data_filename 'S' num2str(-channel(2))     ];
  else           , save_processed_data_filename = [ save_processed_data_filename 'N' num2str( channel(2))     ];
  end
  bmp_filename   = save_processed_data_filename;

%
% Optional Parameters:
%
%   fig_pos       = [<x pos>    <y pos>]
%   fig_width     = [<x width>  <y width (optional>]
%   fig_color     = <color>
%
%   AxisFontSize  = <num>
%   DisplayLegend = TRUE or FALSE
%   DisplayBox    = TRUE or FALSE
%   SquareAxis    = TURE or FALSE
%
%   Title         = <string>
%   XLabel        = <string>
%   YLabel        = <string>
%
%   XLimits       = [ <num>  <num> ]
%   YLimits       = [ <num>  <num> ]
%
%   xtick         = <array>
%   xticklabel    = <array>
%   ytick         = <array>
%   yticklabel    = <array>
%
%   LogXData      = TRUE or FALSE
%   LogYData      = TRUE or FALSE
%
%   ReverseXaxis  = TRUE or FALSE
%   ReverseYaxis  = TRUE or FALSE
%
%   SquareAxis    = TRUE or FALSE
%
%   postPlot      = <commands expressed in a string>
%
%   bmp_filename  = <string>
%


%
% Add Customizations Here
%



%
% Process Data and Generate Graph
%
load_input_externally         = true;

if ProcessData
  load_comparisons_externally = false; 
else
  load_comparisons_externally = true;   
end

if PlotData
  produce_plot_externally     = false; 
else
  produce_plot_externally     = true;   
end
save_processed_data_filepath = [EPIC_DATA_PATH slash curve(1).planet slash curve(1).experiment ...
                                               slash 'MatFiles'      slash save_processed_data_filename];

PlotEpicDiagnostic


