
  ProcessData = true;
  PlotData    = true;

  checkEPICncPATHs
  nc=1;

  curve(nc).name                   = 'Global Mean T';
  curve(nc).planet                 = 'Venus';
  curve(nc).experiment             = 'experiment09';
  curve(nc).nc_file_name           = 'extract.nc';
  curve(nc).process_type           = 'GLOBAL_MEAN_VS_PRESSURE';
  curve(nc).variables(1).name      = 't2';
  curve(nc).calc_variables(1).name = 'p2';
  curve(nc).extract_it             = 3;
  curve(nc).extract_ik             = 'all';
  curve(nc).convert_Pa_to_mbar     = true;
  curve_options(nc).line_type      = '-k';
  curve_options(nc).line_size      = 1;
  curve_options(nc).marker_size    = 8;
  nc=nc+1;

% curve(:).process_type      = 'MAX_CHANNEL_VECTOR'     , 'MAX_CHANNEL_SCALAR'            , 
%                              'MIN_CHANNEL_SCALAR'     , 'ABS_MAX_CHANNEL_SCALAR'        ,
%                              'GLOBAL_MEAN_VS_PRESSURE', 'EQ_POLE_DIFFERENCE_VS_PRESSURE', 
%                           or 'TIME_AVERAGE_EPIC_DATA'


  save_processed_data_filename = 'MeanTemperatureProfile';
  bmp_filename   = save_processed_data_filename;

%
% Optional Parameters:
%
%   fig_pos       = [<x pos>    <y pos>]
%   fig_width     = [<x width>  <y width (optional)>]
%   fig_color     = <color>
%
%   AxisFontSize  = <num>
%   DisplayLegend = TRUE or FALSE
%   DisplayBox    = TRUE or FALSE
%   SquareAxis    = TRUE or FALSE
%
%   Title         = <string>
%   XLabel        = <string>
%   YLabel        = <string>
%
%   XLimits       = [ <num>  <num> ]
%   YLimits       = [ <num>  <num> ]
%
%   xtick         = <array>
%   xticklabel    = <array>
%   ytick         = <array>
%   yticklabel    = <array>
%
%   LogXData      = TRUE or FALSE
%   LogYData      = TRUE or FALSE
%
%   ReverseXaxis  = TRUE or FALSE
%   ReverseYaxis  = TRUE or FALSE
%
%   SquareAxis    = TRUE or FALSE
%
%   postPlot      = <commands expressed in a string>
%
%   bmp_filename  = <string>
%


%
% Add Customizations Here
%



%
% Process Data and Generate Graph
%
load_input_externally         = true;

if ProcessData
  load_comparisons_externally = false; 
else
  load_comparisons_externally = true;   
end

if PlotData
  produce_plot_externally     = false; 
else
  produce_plot_externally     = true;   
end
save_processed_data_filepath = [EPIC_DATA_PATH slash curve(1).planet slash curve(1).experiment ...
                                               slash 'MatFiles'      slash save_processed_data_filename];

PlotEpicDiagnostic


